@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.ecs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property credentialsParameter The authorization credential option to use. The authorization credential options can be provided using either the Amazon Resource Name (ARN) of an AWS Secrets Manager secret or AWS Systems Manager Parameter Store parameter. The ARNs refer to the stored credentials.
 * @property domain A fully qualified domain name hosted by an AWS Directory Service Managed Microsoft AD (Active Directory) or self-hosted AD on Amazon EC2.
 */
public data class TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfig(
    public val credentialsParameter: String,
    public val domain: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.ecs.outputs.TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfig): TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfig =
            TaskDefinitionVolumeFsxWindowsFileServerVolumeConfigurationAuthorizationConfig(
                credentialsParameter = javaType.credentialsParameter(),
                domain = javaType.domain(),
            )
    }
}
