@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin

import com.pulumi.aws.efs.kotlin.outputs.BackupPolicyBackupPolicy
import com.pulumi.aws.efs.kotlin.outputs.BackupPolicyBackupPolicy.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [BackupPolicy].
 */
@PulumiTagMarker
public class BackupPolicyResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: BackupPolicyArgs = BackupPolicyArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend BackupPolicyArgsBuilder.() -> Unit) {
        val builder = BackupPolicyArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): BackupPolicy {
        val builtJavaResource = com.pulumi.aws.efs.BackupPolicy(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return BackupPolicy(builtJavaResource)
    }
}

/**
 * Provides an Elastic File System (EFS) Backup Policy resource.
 * Backup policies turn automatic backups on or off for an existing file system.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const fs = new aws.efs.FileSystem("fs", {creationToken: "my-product"});
 * const policy = new aws.efs.BackupPolicy("policy", {
 *     fileSystemId: fs.id,
 *     backupPolicy: {
 *         status: "ENABLED",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * fs = aws.efs.FileSystem("fs", creation_token="my-product")
 * policy = aws.efs.BackupPolicy("policy",
 *     file_system_id=fs.id,
 *     backup_policy={
 *         "status": "ENABLED",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fs = new Aws.Efs.FileSystem("fs", new()
 *     {
 *         CreationToken = "my-product",
 *     });
 *     var policy = new Aws.Efs.BackupPolicy("policy", new()
 *     {
 *         FileSystemId = fs.Id,
 *         BackupPolicyDetails = new Aws.Efs.Inputs.BackupPolicyBackupPolicyArgs
 *         {
 *             Status = "ENABLED",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/efs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		fs, err := efs.NewFileSystem(ctx, "fs", &efs.FileSystemArgs{
 * 			CreationToken: pulumi.String("my-product"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = efs.NewBackupPolicy(ctx, "policy", &efs.BackupPolicyArgs{
 * 			FileSystemId: fs.ID(),
 * 			BackupPolicy: &efs.BackupPolicyBackupPolicyArgs{
 * 				Status: pulumi.String("ENABLED"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.efs.FileSystem;
 * import com.pulumi.aws.efs.FileSystemArgs;
 * import com.pulumi.aws.efs.BackupPolicy;
 * import com.pulumi.aws.efs.BackupPolicyArgs;
 * import com.pulumi.aws.efs.inputs.BackupPolicyBackupPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fs = new FileSystem("fs", FileSystemArgs.builder()
 *             .creationToken("my-product")
 *             .build());
 *         var policy = new BackupPolicy("policy", BackupPolicyArgs.builder()
 *             .fileSystemId(fs.id())
 *             .backupPolicy(BackupPolicyBackupPolicyArgs.builder()
 *                 .status("ENABLED")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   fs:
 *     type: aws:efs:FileSystem
 *     properties:
 *       creationToken: my-product
 *   policy:
 *     type: aws:efs:BackupPolicy
 *     properties:
 *       fileSystemId: ${fs.id}
 *       backupPolicy:
 *         status: ENABLED
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import the EFS backup policies using the `id`. For example:
 * ```sh
 * $ pulumi import aws:efs/backupPolicy:BackupPolicy example fs-6fa144c6
 * ```
 */
public class BackupPolicy internal constructor(
    override val javaResource: com.pulumi.aws.efs.BackupPolicy,
) : KotlinCustomResource(javaResource, BackupPolicyMapper) {
    /**
     * A backup_policy object (documented below).
     */
    public val backupPolicy: Output<BackupPolicyBackupPolicy>
        get() = javaResource.backupPolicy().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * The ID of the EFS file system.
     */
    public val fileSystemId: Output<String>
        get() = javaResource.fileSystemId().applyValue({ args0 -> args0 })
}

public object BackupPolicyMapper : ResourceMapper<BackupPolicy> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.efs.BackupPolicy::class == javaResource::class

    override fun map(javaResource: Resource): BackupPolicy = BackupPolicy(
        javaResource as
            com.pulumi.aws.efs.BackupPolicy,
    )
}

/**
 * @see [BackupPolicy].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [BackupPolicy].
 */
public suspend fun backupPolicy(
    name: String,
    block: suspend BackupPolicyResourceBuilder.() -> Unit,
): BackupPolicy {
    val builder = BackupPolicyResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [BackupPolicy].
 * @param name The _unique_ name of the resulting resource.
 */
public fun backupPolicy(name: String): BackupPolicy {
    val builder = BackupPolicyResourceBuilder()
    builder.name(name)
    return builder.build()
}
