@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin

import com.pulumi.aws.efs.FileSystemArgs.builder
import com.pulumi.aws.efs.kotlin.inputs.FileSystemLifecyclePolicyArgs
import com.pulumi.aws.efs.kotlin.inputs.FileSystemLifecyclePolicyArgsBuilder
import com.pulumi.aws.efs.kotlin.inputs.FileSystemProtectionArgs
import com.pulumi.aws.efs.kotlin.inputs.FileSystemProtectionArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Double
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an Elastic File System (EFS) File System resource.
 * ## Example Usage
 * ### EFS File System w/ tags
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const foo = new aws.efs.FileSystem("foo", {
 *     creationToken: "my-product",
 *     tags: {
 *         Name: "MyProduct",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * foo = aws.efs.FileSystem("foo",
 *     creation_token="my-product",
 *     tags={
 *         "Name": "MyProduct",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var foo = new Aws.Efs.FileSystem("foo", new()
 *     {
 *         CreationToken = "my-product",
 *         Tags =
 *         {
 *             { "Name", "MyProduct" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/efs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := efs.NewFileSystem(ctx, "foo", &efs.FileSystemArgs{
 * 			CreationToken: pulumi.String("my-product"),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("MyProduct"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.efs.FileSystem;
 * import com.pulumi.aws.efs.FileSystemArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var foo = new FileSystem("foo", FileSystemArgs.builder()
 *             .creationToken("my-product")
 *             .tags(Map.of("Name", "MyProduct"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   foo:
 *     type: aws:efs:FileSystem
 *     properties:
 *       creationToken: my-product
 *       tags:
 *         Name: MyProduct
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Using lifecycle policy
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const fooWithLifecylePolicy = new aws.efs.FileSystem("foo_with_lifecyle_policy", {
 *     creationToken: "my-product",
 *     lifecyclePolicies: [{
 *         transitionToIa: "AFTER_30_DAYS",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * foo_with_lifecyle_policy = aws.efs.FileSystem("foo_with_lifecyle_policy",
 *     creation_token="my-product",
 *     lifecycle_policies=[{
 *         "transition_to_ia": "AFTER_30_DAYS",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fooWithLifecylePolicy = new Aws.Efs.FileSystem("foo_with_lifecyle_policy", new()
 *     {
 *         CreationToken = "my-product",
 *         LifecyclePolicies = new[]
 *         {
 *             new Aws.Efs.Inputs.FileSystemLifecyclePolicyArgs
 *             {
 *                 TransitionToIa = "AFTER_30_DAYS",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/efs"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := efs.NewFileSystem(ctx, "foo_with_lifecyle_policy", &efs.FileSystemArgs{
 * 			CreationToken: pulumi.String("my-product"),
 * 			LifecyclePolicies: efs.FileSystemLifecyclePolicyArray{
 * 				&efs.FileSystemLifecyclePolicyArgs{
 * 					TransitionToIa: pulumi.String("AFTER_30_DAYS"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.efs.FileSystem;
 * import com.pulumi.aws.efs.FileSystemArgs;
 * import com.pulumi.aws.efs.inputs.FileSystemLifecyclePolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fooWithLifecylePolicy = new FileSystem("fooWithLifecylePolicy", FileSystemArgs.builder()
 *             .creationToken("my-product")
 *             .lifecyclePolicies(FileSystemLifecyclePolicyArgs.builder()
 *                 .transitionToIa("AFTER_30_DAYS")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   fooWithLifecylePolicy:
 *     type: aws:efs:FileSystem
 *     name: foo_with_lifecyle_policy
 *     properties:
 *       creationToken: my-product
 *       lifecyclePolicies:
 *         - transitionToIa: AFTER_30_DAYS
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import the EFS file systems using the `id`. For example:
 * ```sh
 * $ pulumi import aws:efs/fileSystem:FileSystem foo fs-6fa144c6
 * ```
 * @property availabilityZoneName the AWS Availability Zone in which to create the file system. Used to create a file system that uses One Zone storage classes. See [user guide](https://docs.aws.amazon.com/efs/latest/ug/availability-durability.html) for more information.
 * @property creationToken A unique name (a maximum of 64 characters are allowed)
 * used as reference when creating the Elastic File System to ensure idempotent file
 * system creation. By default generated by this provider. See [Elastic File System]
 * user guide for more information.
 * @property encrypted If true, the disk will be encrypted.
 * @property kmsKeyId The ARN for the KMS encryption key. When specifying kms_key_id, encrypted needs to be set to true.
 * @property lifecyclePolicies A file system [lifecycle policy](https://docs.aws.amazon.com/efs/latest/ug/API_LifecyclePolicy.html) object. See `lifecycle_policy` block below for details.
 * @property performanceMode The file system performance mode. Can be either `"generalPurpose"` or `"maxIO"` (Default: `"generalPurpose"`).
 * @property protection A file system [protection](https://docs.aws.amazon.com/efs/latest/ug/API_FileSystemProtectionDescription.html) object. See `protection` block below for details.
 * @property provisionedThroughputInMibps The throughput, measured in MiB/s, that you want to provision for the file system. Only applicable with `throughput_mode` set to `provisioned`.
 * @property tags A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property throughputMode Throughput mode for the file system. Defaults to `bursting`. Valid values: `bursting`, `provisioned`, or `elastic`. When using `provisioned`, also set `provisioned_throughput_in_mibps`.
 */
public data class FileSystemArgs(
    public val availabilityZoneName: Output<String>? = null,
    public val creationToken: Output<String>? = null,
    public val encrypted: Output<Boolean>? = null,
    public val kmsKeyId: Output<String>? = null,
    public val lifecyclePolicies: Output<List<FileSystemLifecyclePolicyArgs>>? = null,
    public val performanceMode: Output<String>? = null,
    public val protection: Output<FileSystemProtectionArgs>? = null,
    public val provisionedThroughputInMibps: Output<Double>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val throughputMode: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.efs.FileSystemArgs> {
    override fun toJava(): com.pulumi.aws.efs.FileSystemArgs =
        com.pulumi.aws.efs.FileSystemArgs.builder()
            .availabilityZoneName(availabilityZoneName?.applyValue({ args0 -> args0 }))
            .creationToken(creationToken?.applyValue({ args0 -> args0 }))
            .encrypted(encrypted?.applyValue({ args0 -> args0 }))
            .kmsKeyId(kmsKeyId?.applyValue({ args0 -> args0 }))
            .lifecyclePolicies(
                lifecyclePolicies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .performanceMode(performanceMode?.applyValue({ args0 -> args0 }))
            .protection(protection?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .provisionedThroughputInMibps(provisionedThroughputInMibps?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .throughputMode(throughputMode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FileSystemArgs].
 */
@PulumiTagMarker
public class FileSystemArgsBuilder internal constructor() {
    private var availabilityZoneName: Output<String>? = null

    private var creationToken: Output<String>? = null

    private var encrypted: Output<Boolean>? = null

    private var kmsKeyId: Output<String>? = null

    private var lifecyclePolicies: Output<List<FileSystemLifecyclePolicyArgs>>? = null

    private var performanceMode: Output<String>? = null

    private var protection: Output<FileSystemProtectionArgs>? = null

    private var provisionedThroughputInMibps: Output<Double>? = null

    private var tags: Output<Map<String, String>>? = null

    private var throughputMode: Output<String>? = null

    /**
     * @param value the AWS Availability Zone in which to create the file system. Used to create a file system that uses One Zone storage classes. See [user guide](https://docs.aws.amazon.com/efs/latest/ug/availability-durability.html) for more information.
     */
    @JvmName("kuhdlubbamsrsbfd")
    public suspend fun availabilityZoneName(`value`: Output<String>) {
        this.availabilityZoneName = value
    }

    /**
     * @param value A unique name (a maximum of 64 characters are allowed)
     * used as reference when creating the Elastic File System to ensure idempotent file
     * system creation. By default generated by this provider. See [Elastic File System]
     * user guide for more information.
     */
    @JvmName("uvnumnyrmtsanbfy")
    public suspend fun creationToken(`value`: Output<String>) {
        this.creationToken = value
    }

    /**
     * @param value If true, the disk will be encrypted.
     */
    @JvmName("fnucxibqvibtmxhl")
    public suspend fun encrypted(`value`: Output<Boolean>) {
        this.encrypted = value
    }

    /**
     * @param value The ARN for the KMS encryption key. When specifying kms_key_id, encrypted needs to be set to true.
     */
    @JvmName("nxivcsdcwswelhgo")
    public suspend fun kmsKeyId(`value`: Output<String>) {
        this.kmsKeyId = value
    }

    /**
     * @param value A file system [lifecycle policy](https://docs.aws.amazon.com/efs/latest/ug/API_LifecyclePolicy.html) object. See `lifecycle_policy` block below for details.
     */
    @JvmName("rmneklpxgipiasyk")
    public suspend fun lifecyclePolicies(`value`: Output<List<FileSystemLifecyclePolicyArgs>>) {
        this.lifecyclePolicies = value
    }

    @JvmName("wtipgohanxyalksa")
    public suspend fun lifecyclePolicies(vararg values: Output<FileSystemLifecyclePolicyArgs>) {
        this.lifecyclePolicies = Output.all(values.asList())
    }

    /**
     * @param values A file system [lifecycle policy](https://docs.aws.amazon.com/efs/latest/ug/API_LifecyclePolicy.html) object. See `lifecycle_policy` block below for details.
     */
    @JvmName("dkakjjeulefbkjpl")
    public suspend fun lifecyclePolicies(values: List<Output<FileSystemLifecyclePolicyArgs>>) {
        this.lifecyclePolicies = Output.all(values)
    }

    /**
     * @param value The file system performance mode. Can be either `"generalPurpose"` or `"maxIO"` (Default: `"generalPurpose"`).
     */
    @JvmName("vrvrjyhntmpvvnfc")
    public suspend fun performanceMode(`value`: Output<String>) {
        this.performanceMode = value
    }

    /**
     * @param value A file system [protection](https://docs.aws.amazon.com/efs/latest/ug/API_FileSystemProtectionDescription.html) object. See `protection` block below for details.
     */
    @JvmName("cxqrpehnelqloxym")
    public suspend fun protection(`value`: Output<FileSystemProtectionArgs>) {
        this.protection = value
    }

    /**
     * @param value The throughput, measured in MiB/s, that you want to provision for the file system. Only applicable with `throughput_mode` set to `provisioned`.
     */
    @JvmName("dcrxbqueymraghcp")
    public suspend fun provisionedThroughputInMibps(`value`: Output<Double>) {
        this.provisionedThroughputInMibps = value
    }

    /**
     * @param value A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dueqjdijdodadujd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Throughput mode for the file system. Defaults to `bursting`. Valid values: `bursting`, `provisioned`, or `elastic`. When using `provisioned`, also set `provisioned_throughput_in_mibps`.
     */
    @JvmName("sadqofrheajcbcfl")
    public suspend fun throughputMode(`value`: Output<String>) {
        this.throughputMode = value
    }

    /**
     * @param value the AWS Availability Zone in which to create the file system. Used to create a file system that uses One Zone storage classes. See [user guide](https://docs.aws.amazon.com/efs/latest/ug/availability-durability.html) for more information.
     */
    @JvmName("dcamvbughuwmgwbr")
    public suspend fun availabilityZoneName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availabilityZoneName = mapped
    }

    /**
     * @param value A unique name (a maximum of 64 characters are allowed)
     * used as reference when creating the Elastic File System to ensure idempotent file
     * system creation. By default generated by this provider. See [Elastic File System]
     * user guide for more information.
     */
    @JvmName("yafmmtlvjyqarpfq")
    public suspend fun creationToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.creationToken = mapped
    }

    /**
     * @param value If true, the disk will be encrypted.
     */
    @JvmName("bwplwjxjcrhobqwt")
    public suspend fun encrypted(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encrypted = mapped
    }

    /**
     * @param value The ARN for the KMS encryption key. When specifying kms_key_id, encrypted needs to be set to true.
     */
    @JvmName("pwlplccjyrxtvahf")
    public suspend fun kmsKeyId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kmsKeyId = mapped
    }

    /**
     * @param value A file system [lifecycle policy](https://docs.aws.amazon.com/efs/latest/ug/API_LifecyclePolicy.html) object. See `lifecycle_policy` block below for details.
     */
    @JvmName("pdxbrggfofreibtc")
    public suspend fun lifecyclePolicies(`value`: List<FileSystemLifecyclePolicyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lifecyclePolicies = mapped
    }

    /**
     * @param argument A file system [lifecycle policy](https://docs.aws.amazon.com/efs/latest/ug/API_LifecyclePolicy.html) object. See `lifecycle_policy` block below for details.
     */
    @JvmName("dcykltiqypicshuy")
    public suspend fun lifecyclePolicies(argument: List<suspend FileSystemLifecyclePolicyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FileSystemLifecyclePolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lifecyclePolicies = mapped
    }

    /**
     * @param argument A file system [lifecycle policy](https://docs.aws.amazon.com/efs/latest/ug/API_LifecyclePolicy.html) object. See `lifecycle_policy` block below for details.
     */
    @JvmName("nlvposytyrcksiua")
    public suspend fun lifecyclePolicies(vararg argument: suspend FileSystemLifecyclePolicyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FileSystemLifecyclePolicyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.lifecyclePolicies = mapped
    }

    /**
     * @param argument A file system [lifecycle policy](https://docs.aws.amazon.com/efs/latest/ug/API_LifecyclePolicy.html) object. See `lifecycle_policy` block below for details.
     */
    @JvmName("qtbdcfpkaswpgwog")
    public suspend fun lifecyclePolicies(argument: suspend FileSystemLifecyclePolicyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FileSystemLifecyclePolicyArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.lifecyclePolicies = mapped
    }

    /**
     * @param values A file system [lifecycle policy](https://docs.aws.amazon.com/efs/latest/ug/API_LifecyclePolicy.html) object. See `lifecycle_policy` block below for details.
     */
    @JvmName("inyyifduyxyejpnc")
    public suspend fun lifecyclePolicies(vararg values: FileSystemLifecyclePolicyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.lifecyclePolicies = mapped
    }

    /**
     * @param value The file system performance mode. Can be either `"generalPurpose"` or `"maxIO"` (Default: `"generalPurpose"`).
     */
    @JvmName("ftewjbpgfpgvotic")
    public suspend fun performanceMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.performanceMode = mapped
    }

    /**
     * @param value A file system [protection](https://docs.aws.amazon.com/efs/latest/ug/API_FileSystemProtectionDescription.html) object. See `protection` block below for details.
     */
    @JvmName("nisdgfhhcgxsqadl")
    public suspend fun protection(`value`: FileSystemProtectionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protection = mapped
    }

    /**
     * @param argument A file system [protection](https://docs.aws.amazon.com/efs/latest/ug/API_FileSystemProtectionDescription.html) object. See `protection` block below for details.
     */
    @JvmName("kfmxoreutonfbefj")
    public suspend fun protection(argument: suspend FileSystemProtectionArgsBuilder.() -> Unit) {
        val toBeMapped = FileSystemProtectionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.protection = mapped
    }

    /**
     * @param value The throughput, measured in MiB/s, that you want to provision for the file system. Only applicable with `throughput_mode` set to `provisioned`.
     */
    @JvmName("giskasyoiqyqxxtc")
    public suspend fun provisionedThroughputInMibps(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.provisionedThroughputInMibps = mapped
    }

    /**
     * @param value A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vpkxkmxhwvvprbxv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the file system. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ugelyarbuykujmhr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Throughput mode for the file system. Defaults to `bursting`. Valid values: `bursting`, `provisioned`, or `elastic`. When using `provisioned`, also set `provisioned_throughput_in_mibps`.
     */
    @JvmName("uoqvnyptrdsukbch")
    public suspend fun throughputMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.throughputMode = mapped
    }

    internal fun build(): FileSystemArgs = FileSystemArgs(
        availabilityZoneName = availabilityZoneName,
        creationToken = creationToken,
        encrypted = encrypted,
        kmsKeyId = kmsKeyId,
        lifecyclePolicies = lifecyclePolicies,
        performanceMode = performanceMode,
        protection = protection,
        provisionedThroughputInMibps = provisionedThroughputInMibps,
        tags = tags,
        throughputMode = throughputMode,
    )
}
