@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin

import com.pulumi.aws.efs.FileSystemPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an Elastic File System (EFS) File System Policy resource.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const fs = new aws.efs.FileSystem("fs", {creationToken: "my-product"});
 * const policy = aws.iam.getPolicyDocumentOutput({
 *     statements: [{
 *         sid: "ExampleStatement01",
 *         effect: "Allow",
 *         principals: [{
 *             type: "AWS",
 *             identifiers: ["*"],
 *         }],
 *         actions: [
 *             "elasticfilesystem:ClientMount",
 *             "elasticfilesystem:ClientWrite",
 *         ],
 *         resources: [fs&#46;arn],
 *         conditions: [{
 *             test: "Bool",
 *             variable: "aws:SecureTransport",
 *             values: ["true"],
 *         }],
 *     }],
 * });
 * const policyFileSystemPolicy = new aws.efs.FileSystemPolicy("policy", {
 *     fileSystemId: fs.id,
 *     policy: policy.apply(policy => policy.json),
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * fs = aws.efs.FileSystem("fs", creation_token="my-product")
 * policy = aws.iam.get_policy_document_output(statements=[{
 *     "sid": "ExampleStatement01",
 *     "effect": "Allow",
 *     "principals": [{
 *         "type": "AWS",
 *         "identifiers": ["*"],
 *     }],
 *     "actions": [
 *         "elasticfilesystem:ClientMount",
 *         "elasticfilesystem:ClientWrite",
 *     ],
 *     "resources": [fs&#46;arn],
 *     "conditions": [{
 *         "test": "Bool",
 *         "variable": "aws:SecureTransport",
 *         "values": ["true"],
 *     }],
 * }])
 * policy_file_system_policy = aws.efs.FileSystemPolicy("policy",
 *     file_system_id=fs.id,
 *     policy=policy.json)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var fs = new Aws.Efs.FileSystem("fs", new()
 *     {
 *         CreationToken = "my-product",
 *     });
 *     var policy = Aws.Iam.GetPolicyDocument.Invoke(new()
 *     {
 *         Statements = new[]
 *         {
 *             new Aws.Iam.Inputs.GetPolicyDocumentStatementInputArgs
 *             {
 *                 Sid = "ExampleStatement01",
 *                 Effect = "Allow",
 *                 Principals = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementPrincipalInputArgs
 *                     {
 *                         Type = "AWS",
 *                         Identifiers = new[]
 *                         {
 *                             "*",
 *                         },
 *                     },
 *                 },
 *                 Actions = new[]
 *                 {
 *                     "elasticfilesystem:ClientMount",
 *                     "elasticfilesystem:ClientWrite",
 *                 },
 *                 Resources = new[]
 *                 {
 *                     fs.Arn,
 *                 },
 *                 Conditions = new[]
 *                 {
 *                     new Aws.Iam.Inputs.GetPolicyDocumentStatementConditionInputArgs
 *                     {
 *                         Test = "Bool",
 *                         Variable = "aws:SecureTransport",
 *                         Values = new[]
 *                         {
 *                             "true",
 *                         },
 *                     },
 *                 },
 *             },
 *         },
 *     });
 *     var policyFileSystemPolicy = new Aws.Efs.FileSystemPolicy("policy", new()
 *     {
 *         FileSystemId = fs.Id,
 *         Policy = policy.Apply(getPolicyDocumentResult => getPolicyDocumentResult.Json),
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/efs"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		fs, err := efs.NewFileSystem(ctx, "fs", &efs.FileSystemArgs{
 * 			CreationToken: pulumi.String("my-product"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		policy := iam.GetPolicyDocumentOutput(ctx, iam.GetPolicyDocumentOutputArgs{
 * 			Statements: iam.GetPolicyDocumentStatementArray{
 * 				&iam.GetPolicyDocumentStatementArgs{
 * 					Sid:    pulumi.String("ExampleStatement01"),
 * 					Effect: pulumi.String("Allow"),
 * 					Principals: iam.GetPolicyDocumentStatementPrincipalArray{
 * 						&iam.GetPolicyDocumentStatementPrincipalArgs{
 * 							Type: pulumi.String("AWS"),
 * 							Identifiers: pulumi.StringArray{
 * 								pulumi.String("*"),
 * 							},
 * 						},
 * 					},
 * 					Actions: pulumi.StringArray{
 * 						pulumi.String("elasticfilesystem:ClientMount"),
 * 						pulumi.String("elasticfilesystem:ClientWrite"),
 * 					},
 * 					Resources: pulumi.StringArray{
 * 						fs.Arn,
 * 					},
 * 					Conditions: iam.GetPolicyDocumentStatementConditionArray{
 * 						&iam.GetPolicyDocumentStatementConditionArgs{
 * 							Test:     pulumi.String("Bool"),
 * 							Variable: pulumi.String("aws:SecureTransport"),
 * 							Values: pulumi.StringArray{
 * 								pulumi.String("true"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 			},
 * 		}, nil)
 * 		_, err = efs.NewFileSystemPolicy(ctx, "policy", &efs.FileSystemPolicyArgs{
 * 			FileSystemId: fs.ID(),
 * 			Policy: pulumi.String(policy.ApplyT(func(policy iam.GetPolicyDocumentResult) (*string, error) {
 * 				return &policy.Json, nil
 * 			}).(pulumi.StringPtrOutput)),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.efs.FileSystem;
 * import com.pulumi.aws.efs.FileSystemArgs;
 * import com.pulumi.aws.iam.IamFunctions;
 * import com.pulumi.aws.iam.inputs.GetPolicyDocumentArgs;
 * import com.pulumi.aws.efs.FileSystemPolicy;
 * import com.pulumi.aws.efs.FileSystemPolicyArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var fs = new FileSystem("fs", FileSystemArgs.builder()
 *             .creationToken("my-product")
 *             .build());
 *         final var policy = IamFunctions.getPolicyDocument(GetPolicyDocumentArgs.builder()
 *             .statements(GetPolicyDocumentStatementArgs.builder()
 *                 .sid("ExampleStatement01")
 *                 .effect("Allow")
 *                 .principals(GetPolicyDocumentStatementPrincipalArgs.builder()
 *                     .type("AWS")
 *                     .identifiers("*")
 *                     .build())
 *                 .actions(
 *                     "elasticfilesystem:ClientMount",
 *                     "elasticfilesystem:ClientWrite")
 *                 .resources(fs.arn())
 *                 .conditions(GetPolicyDocumentStatementConditionArgs.builder()
 *                     .test("Bool")
 *                     .variable("aws:SecureTransport")
 *                     .values("true")
 *                     .build())
 *                 .build())
 *             .build());
 *         var policyFileSystemPolicy = new FileSystemPolicy("policyFileSystemPolicy", FileSystemPolicyArgs.builder()
 *             .fileSystemId(fs.id())
 *             .policy(policy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult).applyValue(policy -> policy.applyValue(getPolicyDocumentResult -> getPolicyDocumentResult.json())))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   fs:
 *     type: aws:efs:FileSystem
 *     properties:
 *       creationToken: my-product
 *   policyFileSystemPolicy:
 *     type: aws:efs:FileSystemPolicy
 *     name: policy
 *     properties:
 *       fileSystemId: ${fs.id}
 *       policy: ${policy.json}
 * variables:
 *   policy:
 *     fn::invoke:
 *       Function: aws:iam:getPolicyDocument
 *       Arguments:
 *         statements:
 *           - sid: ExampleStatement01
 *             effect: Allow
 *             principals:
 *               - type: AWS
 *                 identifiers:
 *                   - '*'
 *             actions:
 *               - elasticfilesystem:ClientMount
 *               - elasticfilesystem:ClientWrite
 *             resources:
 *               - ${fs.arn}
 *             conditions:
 *               - test: Bool
 *                 variable: aws:SecureTransport
 *                 values:
 *                   - 'true'
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import the EFS file system policies using the `id`. For example:
 * ```sh
 * $ pulumi import aws:efs/fileSystemPolicy:FileSystemPolicy foo fs-6fa144c6
 * ```
 * @property bypassPolicyLockoutSafetyCheck A flag to indicate whether to bypass the `aws.efs.FileSystemPolicy` lockout safety check. The policy lockout safety check determines whether the policy in the request will prevent the principal making the request will be locked out from making future `PutFileSystemPolicy` requests on the file system. Set `bypass_policy_lockout_safety_check` to `true` only when you intend to prevent the principal that is making the request from making a subsequent `PutFileSystemPolicy` request on the file system. The default value is `false`.
 * @property fileSystemId The ID of the EFS file system.
 * @property policy The JSON formatted file system policy for the EFS file system. see [Docs](https://docs.aws.amazon.com/efs/latest/ug/access-control-overview.html#access-control-manage-access-intro-resource-policies) for more info.
 * The following arguments are optional:
 */
public data class FileSystemPolicyArgs(
    public val bypassPolicyLockoutSafetyCheck: Output<Boolean>? = null,
    public val fileSystemId: Output<String>? = null,
    public val policy: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.efs.FileSystemPolicyArgs> {
    override fun toJava(): com.pulumi.aws.efs.FileSystemPolicyArgs =
        com.pulumi.aws.efs.FileSystemPolicyArgs.builder()
            .bypassPolicyLockoutSafetyCheck(bypassPolicyLockoutSafetyCheck?.applyValue({ args0 -> args0 }))
            .fileSystemId(fileSystemId?.applyValue({ args0 -> args0 }))
            .policy(policy?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FileSystemPolicyArgs].
 */
@PulumiTagMarker
public class FileSystemPolicyArgsBuilder internal constructor() {
    private var bypassPolicyLockoutSafetyCheck: Output<Boolean>? = null

    private var fileSystemId: Output<String>? = null

    private var policy: Output<String>? = null

    /**
     * @param value A flag to indicate whether to bypass the `aws.efs.FileSystemPolicy` lockout safety check. The policy lockout safety check determines whether the policy in the request will prevent the principal making the request will be locked out from making future `PutFileSystemPolicy` requests on the file system. Set `bypass_policy_lockout_safety_check` to `true` only when you intend to prevent the principal that is making the request from making a subsequent `PutFileSystemPolicy` request on the file system. The default value is `false`.
     */
    @JvmName("echxwscxxatqynkb")
    public suspend fun bypassPolicyLockoutSafetyCheck(`value`: Output<Boolean>) {
        this.bypassPolicyLockoutSafetyCheck = value
    }

    /**
     * @param value The ID of the EFS file system.
     */
    @JvmName("mblrvvthhuwwppxi")
    public suspend fun fileSystemId(`value`: Output<String>) {
        this.fileSystemId = value
    }

    /**
     * @param value The JSON formatted file system policy for the EFS file system. see [Docs](https://docs.aws.amazon.com/efs/latest/ug/access-control-overview.html#access-control-manage-access-intro-resource-policies) for more info.
     * The following arguments are optional:
     */
    @JvmName("vbxchrcvjvwqwkmo")
    public suspend fun policy(`value`: Output<String>) {
        this.policy = value
    }

    /**
     * @param value A flag to indicate whether to bypass the `aws.efs.FileSystemPolicy` lockout safety check. The policy lockout safety check determines whether the policy in the request will prevent the principal making the request will be locked out from making future `PutFileSystemPolicy` requests on the file system. Set `bypass_policy_lockout_safety_check` to `true` only when you intend to prevent the principal that is making the request from making a subsequent `PutFileSystemPolicy` request on the file system. The default value is `false`.
     */
    @JvmName("eurnvfekwvawgrli")
    public suspend fun bypassPolicyLockoutSafetyCheck(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bypassPolicyLockoutSafetyCheck = mapped
    }

    /**
     * @param value The ID of the EFS file system.
     */
    @JvmName("xlumjlkvnpjjvegq")
    public suspend fun fileSystemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileSystemId = mapped
    }

    /**
     * @param value The JSON formatted file system policy for the EFS file system. see [Docs](https://docs.aws.amazon.com/efs/latest/ug/access-control-overview.html#access-control-manage-access-intro-resource-policies) for more info.
     * The following arguments are optional:
     */
    @JvmName("ijvntxfxehkixfgv")
    public suspend fun policy(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    internal fun build(): FileSystemPolicyArgs = FileSystemPolicyArgs(
        bypassPolicyLockoutSafetyCheck = bypassPolicyLockoutSafetyCheck,
        fileSystemId = fileSystemId,
        policy = policy,
    )
}
