@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin.inputs

import com.pulumi.aws.efs.inputs.FileSystemLifecyclePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property transitionToArchive Indicates how long it takes to transition files to the archive storage class. Requires transition_to_ia, Elastic Throughput and General Purpose performance mode. Valid values: `AFTER_1_DAY`, `AFTER_7_DAYS`, `AFTER_14_DAYS`, `AFTER_30_DAYS`, `AFTER_60_DAYS`, `AFTER_90_DAYS`, `AFTER_180_DAYS`, `AFTER_270_DAYS`, or `AFTER_365_DAYS`.
 * @property transitionToIa Indicates how long it takes to transition files to the IA storage class. Valid values: `AFTER_1_DAY`, `AFTER_7_DAYS`, `AFTER_14_DAYS`, `AFTER_30_DAYS`, `AFTER_60_DAYS`, `AFTER_90_DAYS`, `AFTER_180_DAYS`, `AFTER_270_DAYS`, or `AFTER_365_DAYS`.
 * @property transitionToPrimaryStorageClass Describes the policy used to transition a file from infequent access storage to primary storage. Valid values: `AFTER_1_ACCESS`.
 */
public data class FileSystemLifecyclePolicyArgs(
    public val transitionToArchive: Output<String>? = null,
    public val transitionToIa: Output<String>? = null,
    public val transitionToPrimaryStorageClass: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.efs.inputs.FileSystemLifecyclePolicyArgs> {
    override fun toJava(): com.pulumi.aws.efs.inputs.FileSystemLifecyclePolicyArgs =
        com.pulumi.aws.efs.inputs.FileSystemLifecyclePolicyArgs.builder()
            .transitionToArchive(transitionToArchive?.applyValue({ args0 -> args0 }))
            .transitionToIa(transitionToIa?.applyValue({ args0 -> args0 }))
            .transitionToPrimaryStorageClass(
                transitionToPrimaryStorageClass?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [FileSystemLifecyclePolicyArgs].
 */
@PulumiTagMarker
public class FileSystemLifecyclePolicyArgsBuilder internal constructor() {
    private var transitionToArchive: Output<String>? = null

    private var transitionToIa: Output<String>? = null

    private var transitionToPrimaryStorageClass: Output<String>? = null

    /**
     * @param value Indicates how long it takes to transition files to the archive storage class. Requires transition_to_ia, Elastic Throughput and General Purpose performance mode. Valid values: `AFTER_1_DAY`, `AFTER_7_DAYS`, `AFTER_14_DAYS`, `AFTER_30_DAYS`, `AFTER_60_DAYS`, `AFTER_90_DAYS`, `AFTER_180_DAYS`, `AFTER_270_DAYS`, or `AFTER_365_DAYS`.
     */
    @JvmName("pyehmcybscvaxxcl")
    public suspend fun transitionToArchive(`value`: Output<String>) {
        this.transitionToArchive = value
    }

    /**
     * @param value Indicates how long it takes to transition files to the IA storage class. Valid values: `AFTER_1_DAY`, `AFTER_7_DAYS`, `AFTER_14_DAYS`, `AFTER_30_DAYS`, `AFTER_60_DAYS`, `AFTER_90_DAYS`, `AFTER_180_DAYS`, `AFTER_270_DAYS`, or `AFTER_365_DAYS`.
     */
    @JvmName("vbeyssrofmfmbjtt")
    public suspend fun transitionToIa(`value`: Output<String>) {
        this.transitionToIa = value
    }

    /**
     * @param value Describes the policy used to transition a file from infequent access storage to primary storage. Valid values: `AFTER_1_ACCESS`.
     */
    @JvmName("wquixakgjdcrbpjg")
    public suspend fun transitionToPrimaryStorageClass(`value`: Output<String>) {
        this.transitionToPrimaryStorageClass = value
    }

    /**
     * @param value Indicates how long it takes to transition files to the archive storage class. Requires transition_to_ia, Elastic Throughput and General Purpose performance mode. Valid values: `AFTER_1_DAY`, `AFTER_7_DAYS`, `AFTER_14_DAYS`, `AFTER_30_DAYS`, `AFTER_60_DAYS`, `AFTER_90_DAYS`, `AFTER_180_DAYS`, `AFTER_270_DAYS`, or `AFTER_365_DAYS`.
     */
    @JvmName("tjuvsgbwwnxuecie")
    public suspend fun transitionToArchive(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitionToArchive = mapped
    }

    /**
     * @param value Indicates how long it takes to transition files to the IA storage class. Valid values: `AFTER_1_DAY`, `AFTER_7_DAYS`, `AFTER_14_DAYS`, `AFTER_30_DAYS`, `AFTER_60_DAYS`, `AFTER_90_DAYS`, `AFTER_180_DAYS`, `AFTER_270_DAYS`, or `AFTER_365_DAYS`.
     */
    @JvmName("kbnuirvcgvjdsbkv")
    public suspend fun transitionToIa(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitionToIa = mapped
    }

    /**
     * @param value Describes the policy used to transition a file from infequent access storage to primary storage. Valid values: `AFTER_1_ACCESS`.
     */
    @JvmName("cptdffllnwjtbmcr")
    public suspend fun transitionToPrimaryStorageClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.transitionToPrimaryStorageClass = mapped
    }

    internal fun build(): FileSystemLifecyclePolicyArgs = FileSystemLifecyclePolicyArgs(
        transitionToArchive = transitionToArchive,
        transitionToIa = transitionToIa,
        transitionToPrimaryStorageClass = transitionToPrimaryStorageClass,
    )
}
