@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin.inputs

import com.pulumi.aws.efs.inputs.FileSystemProtectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property replicationOverwrite Indicates whether replication overwrite protection is enabled. Valid values: `ENABLED` or `DISABLED`.
 */
public data class FileSystemProtectionArgs(
    public val replicationOverwrite: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.efs.inputs.FileSystemProtectionArgs> {
    override fun toJava(): com.pulumi.aws.efs.inputs.FileSystemProtectionArgs =
        com.pulumi.aws.efs.inputs.FileSystemProtectionArgs.builder()
            .replicationOverwrite(replicationOverwrite?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FileSystemProtectionArgs].
 */
@PulumiTagMarker
public class FileSystemProtectionArgsBuilder internal constructor() {
    private var replicationOverwrite: Output<String>? = null

    /**
     * @param value Indicates whether replication overwrite protection is enabled. Valid values: `ENABLED` or `DISABLED`.
     */
    @JvmName("kqbfkqflsxjobxfy")
    public suspend fun replicationOverwrite(`value`: Output<String>) {
        this.replicationOverwrite = value
    }

    /**
     * @param value Indicates whether replication overwrite protection is enabled. Valid values: `ENABLED` or `DISABLED`.
     */
    @JvmName("nolovvunlcikfhro")
    public suspend fun replicationOverwrite(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.replicationOverwrite = mapped
    }

    internal fun build(): FileSystemProtectionArgs = FileSystemProtectionArgs(
        replicationOverwrite = replicationOverwrite,
    )
}
