@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin.inputs

import com.pulumi.aws.efs.inputs.GetAccessPointsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAccessPoints.
 * @property fileSystemId EFS File System identifier.
 */
public data class GetAccessPointsPlainArgs(
    public val fileSystemId: String,
) : ConvertibleToJava<com.pulumi.aws.efs.inputs.GetAccessPointsPlainArgs> {
    override fun toJava(): com.pulumi.aws.efs.inputs.GetAccessPointsPlainArgs =
        com.pulumi.aws.efs.inputs.GetAccessPointsPlainArgs.builder()
            .fileSystemId(fileSystemId.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAccessPointsPlainArgs].
 */
@PulumiTagMarker
public class GetAccessPointsPlainArgsBuilder internal constructor() {
    private var fileSystemId: String? = null

    /**
     * @param value EFS File System identifier.
     */
    @JvmName("tgnhluwqwyrnrsac")
    public suspend fun fileSystemId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.fileSystemId = mapped
    }

    internal fun build(): GetAccessPointsPlainArgs = GetAccessPointsPlainArgs(
        fileSystemId = fileSystemId ?: throw PulumiNullFieldException("fileSystemId"),
    )
}
