@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin.inputs

import com.pulumi.aws.efs.inputs.GetFileSystemPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getFileSystem.
 * @property creationToken Restricts the list to the file system with this creation token.
 * @property fileSystemId ID that identifies the file system (e.g., fs-ccfc0d65).
 * @property tags Restricts the list to the file system with these tags.
 */
public data class GetFileSystemPlainArgs(
    public val creationToken: String? = null,
    public val fileSystemId: String? = null,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.efs.inputs.GetFileSystemPlainArgs> {
    override fun toJava(): com.pulumi.aws.efs.inputs.GetFileSystemPlainArgs =
        com.pulumi.aws.efs.inputs.GetFileSystemPlainArgs.builder()
            .creationToken(creationToken?.let({ args0 -> args0 }))
            .fileSystemId(fileSystemId?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetFileSystemPlainArgs].
 */
@PulumiTagMarker
public class GetFileSystemPlainArgsBuilder internal constructor() {
    private var creationToken: String? = null

    private var fileSystemId: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Restricts the list to the file system with this creation token.
     */
    @JvmName("kquwhodegrcnuani")
    public suspend fun creationToken(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.creationToken = mapped
    }

    /**
     * @param value ID that identifies the file system (e.g., fs-ccfc0d65).
     */
    @JvmName("ycfgnesbijuqkffr")
    public suspend fun fileSystemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.fileSystemId = mapped
    }

    /**
     * @param value Restricts the list to the file system with these tags.
     */
    @JvmName("vaiuoesxdynwgexc")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Restricts the list to the file system with these tags.
     */
    @JvmName("pjsvkerovpuavyrn")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetFileSystemPlainArgs = GetFileSystemPlainArgs(
        creationToken = creationToken,
        fileSystemId = fileSystemId,
        tags = tags,
    )
}
