@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin.inputs

import com.pulumi.aws.efs.inputs.GetMountTargetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getMountTarget.
 * @property accessPointId ID or ARN of the access point whose mount target that you want to find. It must be included if a `file_system_id` and `mount_target_id` are not included.
 * @property fileSystemId ID or ARN of the file system whose mount target that you want to find. It must be included if an `access_point_id` and `mount_target_id` are not included.
 * @property mountTargetId ID or ARN of the mount target that you want to find. It must be included in your request if an `access_point_id` and `file_system_id` are not included.
 */
public data class GetMountTargetPlainArgs(
    public val accessPointId: String? = null,
    public val fileSystemId: String? = null,
    public val mountTargetId: String? = null,
) : ConvertibleToJava<com.pulumi.aws.efs.inputs.GetMountTargetPlainArgs> {
    override fun toJava(): com.pulumi.aws.efs.inputs.GetMountTargetPlainArgs =
        com.pulumi.aws.efs.inputs.GetMountTargetPlainArgs.builder()
            .accessPointId(accessPointId?.let({ args0 -> args0 }))
            .fileSystemId(fileSystemId?.let({ args0 -> args0 }))
            .mountTargetId(mountTargetId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMountTargetPlainArgs].
 */
@PulumiTagMarker
public class GetMountTargetPlainArgsBuilder internal constructor() {
    private var accessPointId: String? = null

    private var fileSystemId: String? = null

    private var mountTargetId: String? = null

    /**
     * @param value ID or ARN of the access point whose mount target that you want to find. It must be included if a `file_system_id` and `mount_target_id` are not included.
     */
    @JvmName("cvsbrilryjsbawej")
    public suspend fun accessPointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.accessPointId = mapped
    }

    /**
     * @param value ID or ARN of the file system whose mount target that you want to find. It must be included if an `access_point_id` and `mount_target_id` are not included.
     */
    @JvmName("ndosrtqrqsepwgyx")
    public suspend fun fileSystemId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.fileSystemId = mapped
    }

    /**
     * @param value ID or ARN of the mount target that you want to find. It must be included in your request if an `access_point_id` and `file_system_id` are not included.
     */
    @JvmName("tbvnguikrxbmrawv")
    public suspend fun mountTargetId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.mountTargetId = mapped
    }

    internal fun build(): GetMountTargetPlainArgs = GetMountTargetPlainArgs(
        accessPointId = accessPointId,
        fileSystemId = fileSystemId,
        mountTargetId = mountTargetId,
    )
}
