@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin.outputs

import kotlin.Int
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property gid POSIX group ID used for all file system operations using this access point.
 * @property secondaryGids Secondary POSIX group IDs used for all file system operations using this access point.
 * @property uid POSIX user ID used for all file system operations using this access point.
 */
public data class AccessPointPosixUser(
    public val gid: Int,
    public val secondaryGids: List<Int>? = null,
    public val uid: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.efs.outputs.AccessPointPosixUser): AccessPointPosixUser = AccessPointPosixUser(
            gid = javaType.gid(),
            secondaryGids = javaType.secondaryGids().map({ args0 -> args0 }),
            uid = javaType.uid(),
        )
    }
}
