@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property creationInfo POSIX IDs and permissions to apply to the access point's Root Directory. See Creation Info below.
 * @property path Path on the EFS file system to expose as the root directory to NFS clients using the access point to access the EFS file system. A path can have up to four subdirectories. If the specified path does not exist, you are required to provide `creation_info`.
 */
public data class AccessPointRootDirectory(
    public val creationInfo: AccessPointRootDirectoryCreationInfo? = null,
    public val path: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.efs.outputs.AccessPointRootDirectory): AccessPointRootDirectory = AccessPointRootDirectory(
            creationInfo = javaType.creationInfo().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.efs.kotlin.outputs.AccessPointRootDirectoryCreationInfo.Companion.toKotlin(args0)
                })
            }).orElse(null),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
        )
    }
}
