@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property transitionToArchive Indicates how long it takes to transition files to the archive storage class. Requires transition_to_ia, Elastic Throughput and General Purpose performance mode. Valid values: `AFTER_1_DAY`, `AFTER_7_DAYS`, `AFTER_14_DAYS`, `AFTER_30_DAYS`, `AFTER_60_DAYS`, `AFTER_90_DAYS`, `AFTER_180_DAYS`, `AFTER_270_DAYS`, or `AFTER_365_DAYS`.
 * @property transitionToIa Indicates how long it takes to transition files to the IA storage class. Valid values: `AFTER_1_DAY`, `AFTER_7_DAYS`, `AFTER_14_DAYS`, `AFTER_30_DAYS`, `AFTER_60_DAYS`, `AFTER_90_DAYS`, `AFTER_180_DAYS`, `AFTER_270_DAYS`, or `AFTER_365_DAYS`.
 * @property transitionToPrimaryStorageClass Describes the policy used to transition a file from infequent access storage to primary storage. Valid values: `AFTER_1_ACCESS`.
 */
public data class FileSystemLifecyclePolicy(
    public val transitionToArchive: String? = null,
    public val transitionToIa: String? = null,
    public val transitionToPrimaryStorageClass: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.efs.outputs.FileSystemLifecyclePolicy): FileSystemLifecyclePolicy = FileSystemLifecyclePolicy(
            transitionToArchive = javaType.transitionToArchive().map({ args0 -> args0 }).orElse(null),
            transitionToIa = javaType.transitionToIa().map({ args0 -> args0 }).orElse(null),
            transitionToPrimaryStorageClass = javaType.transitionToPrimaryStorageClass().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
