@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property value The latest known metered size (in bytes) of data stored in the file system.
 * @property valueInIa The latest known metered size (in bytes) of data stored in the Infrequent Access storage class.
 * @property valueInStandard The latest known metered size (in bytes) of data stored in the Standard storage class.
 */
public data class FileSystemSizeInByte(
    public val `value`: Int? = null,
    public val valueInIa: Int? = null,
    public val valueInStandard: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.efs.outputs.FileSystemSizeInByte): FileSystemSizeInByte = FileSystemSizeInByte(
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
            valueInIa = javaType.valueInIa().map({ args0 -> args0 }).orElse(null),
            valueInStandard = javaType.valueInStandard().map({ args0 -> args0 }).orElse(null),
        )
    }
}
