@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getAccessPoint.
 * @property accessPointId
 * @property arn Amazon Resource Name of the file system.
 * @property fileSystemArn Amazon Resource Name of the file system.
 * @property fileSystemId ID of the file system for which the access point is intended.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ownerId
 * @property posixUsers Single element list containing operating system user and group applied to all file system requests made using the access point.
 * @property rootDirectories Single element list containing information on the directory on the Amazon EFS file system that the access point provides access to.
 * @property tags Key-value mapping of resource tags.
 */
public data class GetAccessPointResult(
    public val accessPointId: String,
    public val arn: String,
    public val fileSystemArn: String,
    public val fileSystemId: String,
    public val id: String,
    public val ownerId: String,
    public val posixUsers: List<GetAccessPointPosixUser>,
    public val rootDirectories: List<GetAccessPointRootDirectory>,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.efs.outputs.GetAccessPointResult): GetAccessPointResult = GetAccessPointResult(
            accessPointId = javaType.accessPointId(),
            arn = javaType.arn(),
            fileSystemArn = javaType.fileSystemArn(),
            fileSystemId = javaType.fileSystemId(),
            id = javaType.id(),
            ownerId = javaType.ownerId(),
            posixUsers = javaType.posixUsers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.efs.kotlin.outputs.GetAccessPointPosixUser.Companion.toKotlin(args0)
                })
            }),
            rootDirectories = javaType.rootDirectories().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.efs.kotlin.outputs.GetAccessPointRootDirectory.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
