@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAccessPoints.
 * @property arns Set of Amazon Resource Names (ARNs).
 * @property fileSystemId
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids Set of identifiers.
 */
public data class GetAccessPointsResult(
    public val arns: List<String>,
    public val fileSystemId: String,
    public val id: String,
    public val ids: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.efs.outputs.GetAccessPointsResult): GetAccessPointsResult = GetAccessPointsResult(
            arns = javaType.arns().map({ args0 -> args0 }),
            fileSystemId = javaType.fileSystemId(),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
        )
    }
}
