@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.efs.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property availabilityZoneName The availability zone in which the replica should be created. If specified, the replica will be created with One Zone storage. If omitted, regional storage will be used.
 * @property fileSystemId The ID of the destination file system for the replication. If no ID is provided, then EFS creates a new file system with the default settings.
 * @property kmsKeyId The Key ID, ARN, alias, or alias ARN of the KMS key that should be used to encrypt the replica file system. If omitted, the default KMS key for EFS `/aws/elasticfilesystem` will be used.
 * @property region The region in which the replica should be created.
 * @property status
 */
public data class ReplicationConfigurationDestination(
    public val availabilityZoneName: String? = null,
    public val fileSystemId: String? = null,
    public val kmsKeyId: String? = null,
    public val region: String? = null,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.efs.outputs.ReplicationConfigurationDestination): ReplicationConfigurationDestination = ReplicationConfigurationDestination(
            availabilityZoneName = javaType.availabilityZoneName().map({ args0 -> args0 }).orElse(null),
            fileSystemId = javaType.fileSystemId().map({ args0 -> args0 }).orElse(null),
            kmsKeyId = javaType.kmsKeyId().map({ args0 -> args0 }).orElse(null),
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
