@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [AccessEntry].
 */
@PulumiTagMarker
public class AccessEntryResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccessEntryArgs = AccessEntryArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccessEntryArgsBuilder.() -> Unit) {
        val builder = AccessEntryArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AccessEntry {
        val builtJavaResource = com.pulumi.aws.eks.AccessEntry(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AccessEntry(builtJavaResource)
    }
}

/**
 * Access Entry Configurations for an EKS Cluster.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.eks.AccessEntry("example", {
 *     clusterName: exampleAwsEksCluster.name,
 *     principalArn: exampleAwsIamRole.arn,
 *     kubernetesGroups: [
 *         "group-1",
 *         "group-2",
 *     ],
 *     type: "STANDARD",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.eks.AccessEntry("example",
 *     cluster_name=example_aws_eks_cluster["name"],
 *     principal_arn=example_aws_iam_role["arn"],
 *     kubernetes_groups=[
 *         "group-1",
 *         "group-2",
 *     ],
 *     type="STANDARD")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Eks.AccessEntry("example", new()
 *     {
 *         ClusterName = exampleAwsEksCluster.Name,
 *         PrincipalArn = exampleAwsIamRole.Arn,
 *         KubernetesGroups = new[]
 *         {
 *             "group-1",
 *             "group-2",
 *         },
 *         Type = "STANDARD",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/eks"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eks.NewAccessEntry(ctx, "example", &eks.AccessEntryArgs{
 * 			ClusterName:  pulumi.Any(exampleAwsEksCluster.Name),
 * 			PrincipalArn: pulumi.Any(exampleAwsIamRole.Arn),
 * 			KubernetesGroups: pulumi.StringArray{
 * 				pulumi.String("group-1"),
 * 				pulumi.String("group-2"),
 * 			},
 * 			Type: pulumi.String("STANDARD"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.eks.AccessEntry;
 * import com.pulumi.aws.eks.AccessEntryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AccessEntry("example", AccessEntryArgs.builder()
 *             .clusterName(exampleAwsEksCluster.name())
 *             .principalArn(exampleAwsIamRole.arn())
 *             .kubernetesGroups(
 *                 "group-1",
 *                 "group-2")
 *             .type("STANDARD")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:eks:AccessEntry
 *     properties:
 *       clusterName: ${exampleAwsEksCluster.name}
 *       principalArn: ${exampleAwsIamRole.arn}
 *       kubernetesGroups:
 *         - group-1
 *         - group-2
 *       type: STANDARD
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EKS access entry using the `cluster_name` and `principal_arn` separated by a colon (`:`). For example:
 * ```sh
 * $ pulumi import aws:eks/accessEntry:AccessEntry my_eks_access_entry my_cluster_name:my_principal_arn
 * ```
 */
public class AccessEntry internal constructor(
    override val javaResource: com.pulumi.aws.eks.AccessEntry,
) : KotlinCustomResource(javaResource, AccessEntryMapper) {
    /**
     * Amazon Resource Name (ARN) of the Access Entry.
     */
    public val accessEntryArn: Output<String>
        get() = javaResource.accessEntryArn().applyValue({ args0 -> args0 })

    /**
     * Name of the EKS Cluster.
     */
    public val clusterName: Output<String>
        get() = javaResource.clusterName().applyValue({ args0 -> args0 })

    /**
     * Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was created.
     */
    public val createdAt: Output<String>
        get() = javaResource.createdAt().applyValue({ args0 -> args0 })

    /**
     * List of string which can optionally specify the Kubernetes groups the user would belong to when creating an access entry.
     */
    public val kubernetesGroups: Output<List<String>>
        get() = javaResource.kubernetesGroups().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was updated.
     */
    public val modifiedAt: Output<String>
        get() = javaResource.modifiedAt().applyValue({ args0 -> args0 })

    /**
     * The IAM Principal ARN which requires Authentication access to the EKS cluster.
     * The following arguments are optional:
     */
    public val principalArn: Output<String>
        get() = javaResource.principalArn().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * (Optional) Key-value map of resource tags, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Defaults to STANDARD which provides the standard workflow. EC2_LINUX, EC2_WINDOWS, FARGATE_LINUX types disallow users to input a username or groups, and prevent associations.
     */
    public val type: Output<String>?
        get() = javaResource.type().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Defaults to principal ARN if user is principal else defaults to assume-role/session-name is role is used.
     */
    public val userName: Output<String>
        get() = javaResource.userName().applyValue({ args0 -> args0 })
}

public object AccessEntryMapper : ResourceMapper<AccessEntry> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.eks.AccessEntry::class == javaResource::class

    override fun map(javaResource: Resource): AccessEntry = AccessEntry(
        javaResource as
            com.pulumi.aws.eks.AccessEntry,
    )
}

/**
 * @see [AccessEntry].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccessEntry].
 */
public suspend fun accessEntry(name: String, block: suspend AccessEntryResourceBuilder.() -> Unit): AccessEntry {
    val builder = AccessEntryResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccessEntry].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accessEntry(name: String): AccessEntry {
    val builder = AccessEntryResourceBuilder()
    builder.name(name)
    return builder.build()
}
