@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin

import com.pulumi.aws.eks.AccessEntryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Access Entry Configurations for an EKS Cluster.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.eks.AccessEntry("example", {
 *     clusterName: exampleAwsEksCluster.name,
 *     principalArn: exampleAwsIamRole.arn,
 *     kubernetesGroups: [
 *         "group-1",
 *         "group-2",
 *     ],
 *     type: "STANDARD",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.eks.AccessEntry("example",
 *     cluster_name=example_aws_eks_cluster["name"],
 *     principal_arn=example_aws_iam_role["arn"],
 *     kubernetes_groups=[
 *         "group-1",
 *         "group-2",
 *     ],
 *     type="STANDARD")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Eks.AccessEntry("example", new()
 *     {
 *         ClusterName = exampleAwsEksCluster.Name,
 *         PrincipalArn = exampleAwsIamRole.Arn,
 *         KubernetesGroups = new[]
 *         {
 *             "group-1",
 *             "group-2",
 *         },
 *         Type = "STANDARD",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/eks"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eks.NewAccessEntry(ctx, "example", &eks.AccessEntryArgs{
 * 			ClusterName:  pulumi.Any(exampleAwsEksCluster.Name),
 * 			PrincipalArn: pulumi.Any(exampleAwsIamRole.Arn),
 * 			KubernetesGroups: pulumi.StringArray{
 * 				pulumi.String("group-1"),
 * 				pulumi.String("group-2"),
 * 			},
 * 			Type: pulumi.String("STANDARD"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.eks.AccessEntry;
 * import com.pulumi.aws.eks.AccessEntryArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AccessEntry("example", AccessEntryArgs.builder()
 *             .clusterName(exampleAwsEksCluster.name())
 *             .principalArn(exampleAwsIamRole.arn())
 *             .kubernetesGroups(
 *                 "group-1",
 *                 "group-2")
 *             .type("STANDARD")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:eks:AccessEntry
 *     properties:
 *       clusterName: ${exampleAwsEksCluster.name}
 *       principalArn: ${exampleAwsIamRole.arn}
 *       kubernetesGroups:
 *         - group-1
 *         - group-2
 *       type: STANDARD
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EKS access entry using the `cluster_name` and `principal_arn` separated by a colon (`:`). For example:
 * ```sh
 * $ pulumi import aws:eks/accessEntry:AccessEntry my_eks_access_entry my_cluster_name:my_principal_arn
 * ```
 * @property clusterName Name of the EKS Cluster.
 * @property kubernetesGroups List of string which can optionally specify the Kubernetes groups the user would belong to when creating an access entry.
 * @property principalArn The IAM Principal ARN which requires Authentication access to the EKS cluster.
 * The following arguments are optional:
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property type Defaults to STANDARD which provides the standard workflow. EC2_LINUX, EC2_WINDOWS, FARGATE_LINUX types disallow users to input a username or groups, and prevent associations.
 * @property userName Defaults to principal ARN if user is principal else defaults to assume-role/session-name is role is used.
 */
public data class AccessEntryArgs(
    public val clusterName: Output<String>? = null,
    public val kubernetesGroups: Output<List<String>>? = null,
    public val principalArn: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.eks.AccessEntryArgs> {
    override fun toJava(): com.pulumi.aws.eks.AccessEntryArgs =
        com.pulumi.aws.eks.AccessEntryArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .kubernetesGroups(kubernetesGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .principalArn(principalArn?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessEntryArgs].
 */
@PulumiTagMarker
public class AccessEntryArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var kubernetesGroups: Output<List<String>>? = null

    private var principalArn: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    private var userName: Output<String>? = null

    /**
     * @param value Name of the EKS Cluster.
     */
    @JvmName("ccpvsqbsbkegmuwt")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value List of string which can optionally specify the Kubernetes groups the user would belong to when creating an access entry.
     */
    @JvmName("ojrxhhpaxvgkkchw")
    public suspend fun kubernetesGroups(`value`: Output<List<String>>) {
        this.kubernetesGroups = value
    }

    @JvmName("cpwphbnvxjgwrecf")
    public suspend fun kubernetesGroups(vararg values: Output<String>) {
        this.kubernetesGroups = Output.all(values.asList())
    }

    /**
     * @param values List of string which can optionally specify the Kubernetes groups the user would belong to when creating an access entry.
     */
    @JvmName("qrlshtrreohapnyl")
    public suspend fun kubernetesGroups(values: List<Output<String>>) {
        this.kubernetesGroups = Output.all(values)
    }

    /**
     * @param value The IAM Principal ARN which requires Authentication access to the EKS cluster.
     * The following arguments are optional:
     */
    @JvmName("smketijmudtfeapf")
    public suspend fun principalArn(`value`: Output<String>) {
        this.principalArn = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("efenhfkhnybyyeng")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Defaults to STANDARD which provides the standard workflow. EC2_LINUX, EC2_WINDOWS, FARGATE_LINUX types disallow users to input a username or groups, and prevent associations.
     */
    @JvmName("ykiatxktdsailjon")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Defaults to principal ARN if user is principal else defaults to assume-role/session-name is role is used.
     */
    @JvmName("fdhybbpmybspeegc")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value Name of the EKS Cluster.
     */
    @JvmName("yavsqwescgpxxmtv")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value List of string which can optionally specify the Kubernetes groups the user would belong to when creating an access entry.
     */
    @JvmName("mlkphgxjtvdsxtdl")
    public suspend fun kubernetesGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.kubernetesGroups = mapped
    }

    /**
     * @param values List of string which can optionally specify the Kubernetes groups the user would belong to when creating an access entry.
     */
    @JvmName("yanhhdwompnabhmw")
    public suspend fun kubernetesGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.kubernetesGroups = mapped
    }

    /**
     * @param value The IAM Principal ARN which requires Authentication access to the EKS cluster.
     * The following arguments are optional:
     */
    @JvmName("sthiekgwgleibsxa")
    public suspend fun principalArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalArn = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("cqrnwsumswayecaj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("aktuntqktiynemqm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Defaults to STANDARD which provides the standard workflow. EC2_LINUX, EC2_WINDOWS, FARGATE_LINUX types disallow users to input a username or groups, and prevent associations.
     */
    @JvmName("lhycslbrvtgvjfqe")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Defaults to principal ARN if user is principal else defaults to assume-role/session-name is role is used.
     */
    @JvmName("gcyjreynyaejsiiv")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): AccessEntryArgs = AccessEntryArgs(
        clusterName = clusterName,
        kubernetesGroups = kubernetesGroups,
        principalArn = principalArn,
        tags = tags,
        type = type,
        userName = userName,
    )
}
