@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin

import com.pulumi.aws.eks.kotlin.outputs.AccessPolicyAssociationAccessScope
import com.pulumi.aws.eks.kotlin.outputs.AccessPolicyAssociationAccessScope.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [AccessPolicyAssociation].
 */
@PulumiTagMarker
public class AccessPolicyAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AccessPolicyAssociationArgs = AccessPolicyAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AccessPolicyAssociationArgsBuilder.() -> Unit) {
        val builder = AccessPolicyAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AccessPolicyAssociation {
        val builtJavaResource = com.pulumi.aws.eks.AccessPolicyAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return AccessPolicyAssociation(builtJavaResource)
    }
}

/**
 * Access Entry Policy Association for an EKS Cluster.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.eks.AccessPolicyAssociation("example", {
 *     clusterName: exampleAwsEksCluster.name,
 *     policyArn: "arn:aws:eks::aws:cluster-access-policy/AmazonEKSViewPolicy",
 *     principalArn: exampleAwsIamUser.arn,
 *     accessScope: {
 *         type: "namespace",
 *         namespaces: ["example-namespace"],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.eks.AccessPolicyAssociation("example",
 *     cluster_name=example_aws_eks_cluster["name"],
 *     policy_arn="arn:aws:eks::aws:cluster-access-policy/AmazonEKSViewPolicy",
 *     principal_arn=example_aws_iam_user["arn"],
 *     access_scope={
 *         "type": "namespace",
 *         "namespaces": ["example-namespace"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Eks.AccessPolicyAssociation("example", new()
 *     {
 *         ClusterName = exampleAwsEksCluster.Name,
 *         PolicyArn = "arn:aws:eks::aws:cluster-access-policy/AmazonEKSViewPolicy",
 *         PrincipalArn = exampleAwsIamUser.Arn,
 *         AccessScope = new Aws.Eks.Inputs.AccessPolicyAssociationAccessScopeArgs
 *         {
 *             Type = "namespace",
 *             Namespaces = new[]
 *             {
 *                 "example-namespace",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/eks"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eks.NewAccessPolicyAssociation(ctx, "example", &eks.AccessPolicyAssociationArgs{
 * 			ClusterName:  pulumi.Any(exampleAwsEksCluster.Name),
 * 			PolicyArn:    pulumi.String("arn:aws:eks::aws:cluster-access-policy/AmazonEKSViewPolicy"),
 * 			PrincipalArn: pulumi.Any(exampleAwsIamUser.Arn),
 * 			AccessScope: &eks.AccessPolicyAssociationAccessScopeArgs{
 * 				Type: pulumi.String("namespace"),
 * 				Namespaces: pulumi.StringArray{
 * 					pulumi.String("example-namespace"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.eks.AccessPolicyAssociation;
 * import com.pulumi.aws.eks.AccessPolicyAssociationArgs;
 * import com.pulumi.aws.eks.inputs.AccessPolicyAssociationAccessScopeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AccessPolicyAssociation("example", AccessPolicyAssociationArgs.builder()
 *             .clusterName(exampleAwsEksCluster.name())
 *             .policyArn("arn:aws:eks::aws:cluster-access-policy/AmazonEKSViewPolicy")
 *             .principalArn(exampleAwsIamUser.arn())
 *             .accessScope(AccessPolicyAssociationAccessScopeArgs.builder()
 *                 .type("namespace")
 *                 .namespaces("example-namespace")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:eks:AccessPolicyAssociation
 *     properties:
 *       clusterName: ${exampleAwsEksCluster.name}
 *       policyArn: arn:aws:eks::aws:cluster-access-policy/AmazonEKSViewPolicy
 *       principalArn: ${exampleAwsIamUser.arn}
 *       accessScope:
 *         type: namespace
 *         namespaces:
 *           - example-namespace
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EKS access entry using the `cluster_name` `principal_arn` and `policy_arn` separated by a colon (`#`). For example:
 * ```sh
 * $ pulumi import aws:eks/accessPolicyAssociation:AccessPolicyAssociation my_eks_access_entry my_cluster_name#my_principal_arn#my_policy_arn
 * ```
 */
public class AccessPolicyAssociation internal constructor(
    override val javaResource: com.pulumi.aws.eks.AccessPolicyAssociation,
) : KotlinCustomResource(javaResource, AccessPolicyAssociationMapper) {
    /**
     * The configuration block to determine the scope of the access. See `access_scope` Block below.
     */
    public val accessScope: Output<AccessPolicyAssociationAccessScope>
        get() = javaResource.accessScope().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the policy was associated.
     */
    public val associatedAt: Output<String>
        get() = javaResource.associatedAt().applyValue({ args0 -> args0 })

    /**
     * Name of the EKS Cluster.
     */
    public val clusterName: Output<String>
        get() = javaResource.clusterName().applyValue({ args0 -> args0 })

    /**
     * Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the policy was updated.
     */
    public val modifiedAt: Output<String>
        get() = javaResource.modifiedAt().applyValue({ args0 -> args0 })

    /**
     * The ARN of the access policy that you're associating.
     */
    public val policyArn: Output<String>
        get() = javaResource.policyArn().applyValue({ args0 -> args0 })

    /**
     * The IAM Principal ARN which requires Authentication access to the EKS cluster.
     */
    public val principalArn: Output<String>
        get() = javaResource.principalArn().applyValue({ args0 -> args0 })
}

public object AccessPolicyAssociationMapper : ResourceMapper<AccessPolicyAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.eks.AccessPolicyAssociation::class == javaResource::class

    override fun map(javaResource: Resource): AccessPolicyAssociation =
        AccessPolicyAssociation(javaResource as com.pulumi.aws.eks.AccessPolicyAssociation)
}

/**
 * @see [AccessPolicyAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AccessPolicyAssociation].
 */
public suspend fun accessPolicyAssociation(
    name: String,
    block: suspend AccessPolicyAssociationResourceBuilder.() -> Unit,
): AccessPolicyAssociation {
    val builder = AccessPolicyAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AccessPolicyAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun accessPolicyAssociation(name: String): AccessPolicyAssociation {
    val builder = AccessPolicyAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
