@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin

import com.pulumi.aws.eks.AccessPolicyAssociationArgs.builder
import com.pulumi.aws.eks.kotlin.inputs.AccessPolicyAssociationAccessScopeArgs
import com.pulumi.aws.eks.kotlin.inputs.AccessPolicyAssociationAccessScopeArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Access Entry Policy Association for an EKS Cluster.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.eks.AccessPolicyAssociation("example", {
 *     clusterName: exampleAwsEksCluster.name,
 *     policyArn: "arn:aws:eks::aws:cluster-access-policy/AmazonEKSViewPolicy",
 *     principalArn: exampleAwsIamUser.arn,
 *     accessScope: {
 *         type: "namespace",
 *         namespaces: ["example-namespace"],
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.eks.AccessPolicyAssociation("example",
 *     cluster_name=example_aws_eks_cluster["name"],
 *     policy_arn="arn:aws:eks::aws:cluster-access-policy/AmazonEKSViewPolicy",
 *     principal_arn=example_aws_iam_user["arn"],
 *     access_scope={
 *         "type": "namespace",
 *         "namespaces": ["example-namespace"],
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Eks.AccessPolicyAssociation("example", new()
 *     {
 *         ClusterName = exampleAwsEksCluster.Name,
 *         PolicyArn = "arn:aws:eks::aws:cluster-access-policy/AmazonEKSViewPolicy",
 *         PrincipalArn = exampleAwsIamUser.Arn,
 *         AccessScope = new Aws.Eks.Inputs.AccessPolicyAssociationAccessScopeArgs
 *         {
 *             Type = "namespace",
 *             Namespaces = new[]
 *             {
 *                 "example-namespace",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/eks"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eks.NewAccessPolicyAssociation(ctx, "example", &eks.AccessPolicyAssociationArgs{
 * 			ClusterName:  pulumi.Any(exampleAwsEksCluster.Name),
 * 			PolicyArn:    pulumi.String("arn:aws:eks::aws:cluster-access-policy/AmazonEKSViewPolicy"),
 * 			PrincipalArn: pulumi.Any(exampleAwsIamUser.Arn),
 * 			AccessScope: &eks.AccessPolicyAssociationAccessScopeArgs{
 * 				Type: pulumi.String("namespace"),
 * 				Namespaces: pulumi.StringArray{
 * 					pulumi.String("example-namespace"),
 * 				},
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.eks.AccessPolicyAssociation;
 * import com.pulumi.aws.eks.AccessPolicyAssociationArgs;
 * import com.pulumi.aws.eks.inputs.AccessPolicyAssociationAccessScopeArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AccessPolicyAssociation("example", AccessPolicyAssociationArgs.builder()
 *             .clusterName(exampleAwsEksCluster.name())
 *             .policyArn("arn:aws:eks::aws:cluster-access-policy/AmazonEKSViewPolicy")
 *             .principalArn(exampleAwsIamUser.arn())
 *             .accessScope(AccessPolicyAssociationAccessScopeArgs.builder()
 *                 .type("namespace")
 *                 .namespaces("example-namespace")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:eks:AccessPolicyAssociation
 *     properties:
 *       clusterName: ${exampleAwsEksCluster.name}
 *       policyArn: arn:aws:eks::aws:cluster-access-policy/AmazonEKSViewPolicy
 *       principalArn: ${exampleAwsIamUser.arn}
 *       accessScope:
 *         type: namespace
 *         namespaces:
 *           - example-namespace
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EKS access entry using the `cluster_name` `principal_arn` and `policy_arn` separated by a colon (`#`). For example:
 * ```sh
 * $ pulumi import aws:eks/accessPolicyAssociation:AccessPolicyAssociation my_eks_access_entry my_cluster_name#my_principal_arn#my_policy_arn
 * ```
 * @property accessScope The configuration block to determine the scope of the access. See `access_scope` Block below.
 * @property clusterName Name of the EKS Cluster.
 * @property policyArn The ARN of the access policy that you're associating.
 * @property principalArn The IAM Principal ARN which requires Authentication access to the EKS cluster.
 */
public data class AccessPolicyAssociationArgs(
    public val accessScope: Output<AccessPolicyAssociationAccessScopeArgs>? = null,
    public val clusterName: Output<String>? = null,
    public val policyArn: Output<String>? = null,
    public val principalArn: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.eks.AccessPolicyAssociationArgs> {
    override fun toJava(): com.pulumi.aws.eks.AccessPolicyAssociationArgs =
        com.pulumi.aws.eks.AccessPolicyAssociationArgs.builder()
            .accessScope(accessScope?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .policyArn(policyArn?.applyValue({ args0 -> args0 }))
            .principalArn(principalArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessPolicyAssociationArgs].
 */
@PulumiTagMarker
public class AccessPolicyAssociationArgsBuilder internal constructor() {
    private var accessScope: Output<AccessPolicyAssociationAccessScopeArgs>? = null

    private var clusterName: Output<String>? = null

    private var policyArn: Output<String>? = null

    private var principalArn: Output<String>? = null

    /**
     * @param value The configuration block to determine the scope of the access. See `access_scope` Block below.
     */
    @JvmName("mobrtdnfpfydrpfj")
    public suspend fun accessScope(`value`: Output<AccessPolicyAssociationAccessScopeArgs>) {
        this.accessScope = value
    }

    /**
     * @param value Name of the EKS Cluster.
     */
    @JvmName("rvppouujhruybnmm")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value The ARN of the access policy that you're associating.
     */
    @JvmName("rlwynxlvmiapyvpm")
    public suspend fun policyArn(`value`: Output<String>) {
        this.policyArn = value
    }

    /**
     * @param value The IAM Principal ARN which requires Authentication access to the EKS cluster.
     */
    @JvmName("qrvqntvsuglshlpy")
    public suspend fun principalArn(`value`: Output<String>) {
        this.principalArn = value
    }

    /**
     * @param value The configuration block to determine the scope of the access. See `access_scope` Block below.
     */
    @JvmName("gwhxhhpaasdbfmkd")
    public suspend fun accessScope(`value`: AccessPolicyAssociationAccessScopeArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessScope = mapped
    }

    /**
     * @param argument The configuration block to determine the scope of the access. See `access_scope` Block below.
     */
    @JvmName("hejpdppnjauceonh")
    public suspend fun accessScope(argument: suspend AccessPolicyAssociationAccessScopeArgsBuilder.() -> Unit) {
        val toBeMapped = AccessPolicyAssociationAccessScopeArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.accessScope = mapped
    }

    /**
     * @param value Name of the EKS Cluster.
     */
    @JvmName("gmtcbqbbooktudjv")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value The ARN of the access policy that you're associating.
     */
    @JvmName("nqjeulqoguthvkax")
    public suspend fun policyArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policyArn = mapped
    }

    /**
     * @param value The IAM Principal ARN which requires Authentication access to the EKS cluster.
     */
    @JvmName("woyfodhsxqjhgdix")
    public suspend fun principalArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.principalArn = mapped
    }

    internal fun build(): AccessPolicyAssociationArgs = AccessPolicyAssociationArgs(
        accessScope = accessScope,
        clusterName = clusterName,
        policyArn = policyArn,
        principalArn = principalArn,
    )
}
