@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin

import com.pulumi.aws.eks.EksFunctions.getAccessEntryPlain
import com.pulumi.aws.eks.EksFunctions.getAddonPlain
import com.pulumi.aws.eks.EksFunctions.getAddonVersionPlain
import com.pulumi.aws.eks.EksFunctions.getClusterAuthPlain
import com.pulumi.aws.eks.EksFunctions.getClusterPlain
import com.pulumi.aws.eks.EksFunctions.getClustersPlain
import com.pulumi.aws.eks.EksFunctions.getNodeGroupPlain
import com.pulumi.aws.eks.EksFunctions.getNodeGroupsPlain
import com.pulumi.aws.eks.kotlin.inputs.GetAccessEntryPlainArgs
import com.pulumi.aws.eks.kotlin.inputs.GetAccessEntryPlainArgsBuilder
import com.pulumi.aws.eks.kotlin.inputs.GetAddonPlainArgs
import com.pulumi.aws.eks.kotlin.inputs.GetAddonPlainArgsBuilder
import com.pulumi.aws.eks.kotlin.inputs.GetAddonVersionPlainArgs
import com.pulumi.aws.eks.kotlin.inputs.GetAddonVersionPlainArgsBuilder
import com.pulumi.aws.eks.kotlin.inputs.GetClusterAuthPlainArgs
import com.pulumi.aws.eks.kotlin.inputs.GetClusterAuthPlainArgsBuilder
import com.pulumi.aws.eks.kotlin.inputs.GetClusterPlainArgs
import com.pulumi.aws.eks.kotlin.inputs.GetClusterPlainArgsBuilder
import com.pulumi.aws.eks.kotlin.inputs.GetNodeGroupPlainArgs
import com.pulumi.aws.eks.kotlin.inputs.GetNodeGroupPlainArgsBuilder
import com.pulumi.aws.eks.kotlin.inputs.GetNodeGroupsPlainArgs
import com.pulumi.aws.eks.kotlin.inputs.GetNodeGroupsPlainArgsBuilder
import com.pulumi.aws.eks.kotlin.outputs.GetAccessEntryResult
import com.pulumi.aws.eks.kotlin.outputs.GetAddonResult
import com.pulumi.aws.eks.kotlin.outputs.GetAddonVersionResult
import com.pulumi.aws.eks.kotlin.outputs.GetClusterAuthResult
import com.pulumi.aws.eks.kotlin.outputs.GetClusterResult
import com.pulumi.aws.eks.kotlin.outputs.GetClustersResult
import com.pulumi.aws.eks.kotlin.outputs.GetNodeGroupResult
import com.pulumi.aws.eks.kotlin.outputs.GetNodeGroupsResult
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.eks.kotlin.outputs.GetAccessEntryResult.Companion.toKotlin as getAccessEntryResultToKotlin
import com.pulumi.aws.eks.kotlin.outputs.GetAddonResult.Companion.toKotlin as getAddonResultToKotlin
import com.pulumi.aws.eks.kotlin.outputs.GetAddonVersionResult.Companion.toKotlin as getAddonVersionResultToKotlin
import com.pulumi.aws.eks.kotlin.outputs.GetClusterAuthResult.Companion.toKotlin as getClusterAuthResultToKotlin
import com.pulumi.aws.eks.kotlin.outputs.GetClusterResult.Companion.toKotlin as getClusterResultToKotlin
import com.pulumi.aws.eks.kotlin.outputs.GetClustersResult.Companion.toKotlin as getClustersResultToKotlin
import com.pulumi.aws.eks.kotlin.outputs.GetNodeGroupResult.Companion.toKotlin as getNodeGroupResultToKotlin
import com.pulumi.aws.eks.kotlin.outputs.GetNodeGroupsResult.Companion.toKotlin as getNodeGroupsResultToKotlin

public object EksFunctions {
    /**
     * Access Entry Configurations for an EKS Cluster.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.eks.getAccessEntry({
     *     clusterName: exampleAwsEksCluster.name,
     *     principalArn: exampleAwsIamRole.arn,
     * });
     * export const eksAccessEntryOutputs = exampleAwsEksAccessEntry;
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.eks.get_access_entry(cluster_name=example_aws_eks_cluster["name"],
     *     principal_arn=example_aws_iam_role["arn"])
     * pulumi.export("eksAccessEntryOutputs", example_aws_eks_access_entry)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Eks.GetAccessEntry.Invoke(new()
     *     {
     *         ClusterName = exampleAwsEksCluster.Name,
     *         PrincipalArn = exampleAwsIamRole.Arn,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["eksAccessEntryOutputs"] = exampleAwsEksAccessEntry,
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/eks"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := eks.LookupAccessEntry(ctx, &eks.LookupAccessEntryArgs{
     * 			ClusterName:  exampleAwsEksCluster.Name,
     * 			PrincipalArn: exampleAwsIamRole.Arn,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("eksAccessEntryOutputs", exampleAwsEksAccessEntry)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.eks.EksFunctions;
     * import com.pulumi.aws.eks.inputs.GetAccessEntryArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EksFunctions.getAccessEntry(GetAccessEntryArgs.builder()
     *             .clusterName(exampleAwsEksCluster.name())
     *             .principalArn(exampleAwsIamRole.arn())
     *             .build());
     *         ctx.export("eksAccessEntryOutputs", exampleAwsEksAccessEntry);
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:eks:getAccessEntry
     *       Arguments:
     *         clusterName: ${exampleAwsEksCluster.name}
     *         principalArn: ${exampleAwsIamRole.arn}
     * outputs:
     *   eksAccessEntryOutputs: ${exampleAwsEksAccessEntry}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAccessEntry.
     * @return A collection of values returned by getAccessEntry.
     */
    public suspend fun getAccessEntry(argument: GetAccessEntryPlainArgs): GetAccessEntryResult =
        getAccessEntryResultToKotlin(getAccessEntryPlain(argument.toJava()).await())

    /**
     * @see [getAccessEntry].
     * @param clusterName Name of the EKS Cluster.
     * @param principalArn The IAM Principal ARN which requires Authentication access to the EKS cluster.
     * @param tags
     * @return A collection of values returned by getAccessEntry.
     */
    public suspend fun getAccessEntry(
        clusterName: String,
        principalArn: String,
        tags: Map<String, String>? = null,
    ): GetAccessEntryResult {
        val argument = GetAccessEntryPlainArgs(
            clusterName = clusterName,
            principalArn = principalArn,
            tags = tags,
        )
        return getAccessEntryResultToKotlin(getAccessEntryPlain(argument.toJava()).await())
    }

    /**
     * @see [getAccessEntry].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;eks&#46;kotlin&#46;inputs&#46;GetAccessEntryPlainArgs].
     * @return A collection of values returned by getAccessEntry.
     */
    public suspend fun getAccessEntry(argument: suspend GetAccessEntryPlainArgsBuilder.() -> Unit): GetAccessEntryResult {
        val builder = GetAccessEntryPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAccessEntryResultToKotlin(getAccessEntryPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about an EKS add-on.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.eks.getAddon({
     *     addonName: "vpc-cni",
     *     clusterName: exampleAwsEksCluster.name,
     * });
     * export const eksAddonOutputs = exampleAwsEksAddon;
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.eks.get_addon(addon_name="vpc-cni",
     *     cluster_name=example_aws_eks_cluster["name"])
     * pulumi.export("eksAddonOutputs", example_aws_eks_addon)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Eks.GetAddon.Invoke(new()
     *     {
     *         AddonName = "vpc-cni",
     *         ClusterName = exampleAwsEksCluster.Name,
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["eksAddonOutputs"] = exampleAwsEksAddon,
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/eks"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := eks.LookupAddon(ctx, &eks.LookupAddonArgs{
     * 			AddonName:   "vpc-cni",
     * 			ClusterName: exampleAwsEksCluster.Name,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("eksAddonOutputs", exampleAwsEksAddon)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.eks.EksFunctions;
     * import com.pulumi.aws.eks.inputs.GetAddonArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EksFunctions.getAddon(GetAddonArgs.builder()
     *             .addonName("vpc-cni")
     *             .clusterName(exampleAwsEksCluster.name())
     *             .build());
     *         ctx.export("eksAddonOutputs", exampleAwsEksAddon);
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:eks:getAddon
     *       Arguments:
     *         addonName: vpc-cni
     *         clusterName: ${exampleAwsEksCluster.name}
     * outputs:
     *   eksAddonOutputs: ${exampleAwsEksAddon}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAddon.
     * @return A collection of values returned by getAddon.
     */
    public suspend fun getAddon(argument: GetAddonPlainArgs): GetAddonResult =
        getAddonResultToKotlin(getAddonPlain(argument.toJava()).await())

    /**
     * @see [getAddon].
     * @param addonName Name of the EKS add-on. The name must match one of
     * the names returned by [list-addon](https://docs.aws.amazon.com/cli/latest/reference/eks/list-addons.html).
     * @param clusterName Name of the EKS Cluster.
     * @param tags
     * @return A collection of values returned by getAddon.
     */
    public suspend fun getAddon(
        addonName: String,
        clusterName: String,
        tags: Map<String, String>? = null,
    ): GetAddonResult {
        val argument = GetAddonPlainArgs(
            addonName = addonName,
            clusterName = clusterName,
            tags = tags,
        )
        return getAddonResultToKotlin(getAddonPlain(argument.toJava()).await())
    }

    /**
     * @see [getAddon].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;eks&#46;kotlin&#46;inputs&#46;GetAddonPlainArgs].
     * @return A collection of values returned by getAddon.
     */
    public suspend fun getAddon(argument: suspend GetAddonPlainArgsBuilder.() -> Unit): GetAddonResult {
        val builder = GetAddonPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAddonResultToKotlin(getAddonPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about a specific EKS add-on version compatible with an EKS cluster version.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * export = async () => {
     *     const default = await aws.eks.getAddonVersion({
     *         addonName: "vpc-cni",
     *         kubernetesVersion: example.version,
     *     });
     *     const latest = await aws.eks.getAddonVersion({
     *         addonName: "vpc-cni",
     *         kubernetesVersion: example.version,
     *         mostRecent: true,
     *     });
     *     const vpcCni = new aws.eks.Addon("vpc_cni", {
     *         clusterName: example.name,
     *         addonName: "vpc-cni",
     *         addonVersion: latest.version,
     *     });
     *     return {
     *         "default": _default.version,
     *         latest: latest.version,
     *     };
     * }
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * default = aws.eks.get_addon_version(addon_name="vpc-cni",
     *     kubernetes_version=example["version"])
     * latest = aws.eks.get_addon_version(addon_name="vpc-cni",
     *     kubernetes_version=example["version"],
     *     most_recent=True)
     * vpc_cni = aws.eks.Addon("vpc_cni",
     *     cluster_name=example["name"],
     *     addon_name="vpc-cni",
     *     addon_version=latest.version)
     * pulumi.export("default", default.version)
     * pulumi.export("latest", latest.version)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var @default = Aws.Eks.GetAddonVersion.Invoke(new()
     *     {
     *         AddonName = "vpc-cni",
     *         KubernetesVersion = example.Version,
     *     });
     *     var latest = Aws.Eks.GetAddonVersion.Invoke(new()
     *     {
     *         AddonName = "vpc-cni",
     *         KubernetesVersion = example.Version,
     *         MostRecent = true,
     *     });
     *     var vpcCni = new Aws.Eks.Addon("vpc_cni", new()
     *     {
     *         ClusterName = example.Name,
     *         AddonName = "vpc-cni",
     *         AddonVersion = latest.Apply(getAddonVersionResult => getAddonVersionResult.Version),
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["default"] = @default.Apply(@default => @default.Apply(getAddonVersionResult => getAddonVersionResult.Version)),
     *         ["latest"] = latest.Apply(getAddonVersionResult => getAddonVersionResult.Version),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/eks"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_default, err := eks.GetAddonVersion(ctx, &eks.GetAddonVersionArgs{
     * 			AddonName:         "vpc-cni",
     * 			KubernetesVersion: example.Version,
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		latest, err := eks.GetAddonVersion(ctx, &eks.GetAddonVersionArgs{
     * 			AddonName:         "vpc-cni",
     * 			KubernetesVersion: example.Version,
     * 			MostRecent:        pulumi.BoolRef(true),
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = eks.NewAddon(ctx, "vpc_cni", &eks.AddonArgs{
     * 			ClusterName:  pulumi.Any(example.Name),
     * 			AddonName:    pulumi.String("vpc-cni"),
     * 			AddonVersion: pulumi.String(latest.Version),
     * 		})
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("default", _default.Version)
     * 		ctx.Export("latest", latest.Version)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.eks.EksFunctions;
     * import com.pulumi.aws.eks.inputs.GetAddonVersionArgs;
     * import com.pulumi.aws.eks.Addon;
     * import com.pulumi.aws.eks.AddonArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var default = EksFunctions.getAddonVersion(GetAddonVersionArgs.builder()
     *             .addonName("vpc-cni")
     *             .kubernetesVersion(example.version())
     *             .build());
     *         final var latest = EksFunctions.getAddonVersion(GetAddonVersionArgs.builder()
     *             .addonName("vpc-cni")
     *             .kubernetesVersion(example.version())
     *             .mostRecent(true)
     *             .build());
     *         var vpcCni = new Addon("vpcCni", AddonArgs.builder()
     *             .clusterName(example.name())
     *             .addonName("vpc-cni")
     *             .addonVersion(latest.applyValue(getAddonVersionResult -> getAddonVersionResult.version()))
     *             .build());
     *         ctx.export("default", default_.version());
     *         ctx.export("latest", latest.applyValue(getAddonVersionResult -> getAddonVersionResult.version()));
     *     }
     * }
     * ```
     * ```yaml
     * resources:
     *   vpcCni:
     *     type: aws:eks:Addon
     *     name: vpc_cni
     *     properties:
     *       clusterName: ${example.name}
     *       addonName: vpc-cni
     *       addonVersion: ${latest.version}
     * variables:
     *   default:
     *     fn::invoke:
     *       Function: aws:eks:getAddonVersion
     *       Arguments:
     *         addonName: vpc-cni
     *         kubernetesVersion: ${example.version}
     *   latest:
     *     fn::invoke:
     *       Function: aws:eks:getAddonVersion
     *       Arguments:
     *         addonName: vpc-cni
     *         kubernetesVersion: ${example.version}
     *         mostRecent: true
     * outputs:
     *   default: ${default.version}
     *   latest: ${latest.version}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getAddonVersion.
     * @return A collection of values returned by getAddonVersion.
     */
    public suspend fun getAddonVersion(argument: GetAddonVersionPlainArgs): GetAddonVersionResult =
        getAddonVersionResultToKotlin(getAddonVersionPlain(argument.toJava()).await())

    /**
     * @see [getAddonVersion].
     * @param addonName Name of the EKS add-on. The name must match one of
     * the names returned by [list-addon](https://docs.aws.amazon.com/cli/latest/reference/eks/list-addons.html).
     * @param kubernetesVersion Version of the EKS Cluster. Must be between 1-100 characters in length. Must begin with an alphanumeric character, and must only contain alphanumeric characters, dashes and underscores (`^[0-9A-Za-z][A-Za-z0-9\-_]+$`).
     * @param mostRecent Determines if the most recent or default version of the addon should be returned.
     * @return A collection of values returned by getAddonVersion.
     */
    public suspend fun getAddonVersion(
        addonName: String,
        kubernetesVersion: String,
        mostRecent: Boolean? = null,
    ): GetAddonVersionResult {
        val argument = GetAddonVersionPlainArgs(
            addonName = addonName,
            kubernetesVersion = kubernetesVersion,
            mostRecent = mostRecent,
        )
        return getAddonVersionResultToKotlin(getAddonVersionPlain(argument.toJava()).await())
    }

    /**
     * @see [getAddonVersion].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;eks&#46;kotlin&#46;inputs&#46;GetAddonVersionPlainArgs].
     * @return A collection of values returned by getAddonVersion.
     */
    public suspend fun getAddonVersion(argument: suspend GetAddonVersionPlainArgsBuilder.() -> Unit): GetAddonVersionResult {
        val builder = GetAddonVersionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getAddonVersionResultToKotlin(getAddonVersionPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve information about an EKS Cluster.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * export = async () => {
     *     const example = await aws.eks.getCluster({
     *         name: "example",
     *     });
     *     return {
     *         endpoint: example.endpoint,
     *         "kubeconfig-certificate-authority-data": example.certificateAuthorities?.[0]?.data,
     *         "identity-oidc-issuer": example.identities?.[0]?&#46;oidcs?&#46;[0]?.issuer,
     *     };
     * }
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.eks.get_cluster(name="example")
     * pulumi.export("endpoint", example.endpoint)
     * pulumi.export("kubeconfig-certificate-authority-data", example.certificate_authorities[0].data)
     * pulumi.export("identity-oidc-issuer", example.identities[0]&#46;oidcs[0].issuer)
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Eks.GetCluster.Invoke(new()
     *     {
     *         Name = "example",
     *     });
     *     return new Dictionary<string, object?>
     *     {
     *         ["endpoint"] = example.Apply(getClusterResult => getClusterResult.Endpoint),
     *         ["kubeconfig-certificate-authority-data"] = example&#46;Apply(getClusterResult => getClusterResult&#46;CertificateAuthorities[0]?.Data),
     *         ["identity-oidc-issuer"] = example&#46;Apply(getClusterResult => getClusterResult&#46;Identities[0]?&#46;Oidcs[0]?.Issuer),
     *     };
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/eks"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		example, err := eks.LookupCluster(ctx, &eks.LookupClusterArgs{
     * 			Name: "example",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		ctx.Export("endpoint", example.Endpoint)
     * 		ctx.Export("kubeconfig-certificate-authority-data", example.CertificateAuthorities[0].Data)
     * 		ctx.Export("identity-oidc-issuer", example.Identities[0]&#46;Oidcs[0].Issuer)
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.eks.EksFunctions;
     * import com.pulumi.aws.eks.inputs.GetClusterArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EksFunctions.getCluster(GetClusterArgs.builder()
     *             .name("example")
     *             .build());
     *         ctx.export("endpoint", example.applyValue(getClusterResult -> getClusterResult.endpoint()));
     *         ctx.export("kubeconfig-certificate-authority-data", example.applyValue(getClusterResult -> getClusterResult.certificateAuthorities()[0].data()));
     *         ctx.export("identity-oidc-issuer", example.applyValue(getClusterResult -> getClusterResult.identities()[0]&#46;oidcs()[0].issuer()));
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:eks:getCluster
     *       Arguments:
     *         name: example
     * outputs:
     *   endpoint: ${example.endpoint}
     *   kubeconfig-certificate-authority-data: ${example.certificateAuthorities[0].data}
     *   # Only available on Kubernetes version 1.13 and 1.14 clusters created or upgraded on or after September 3, 2019.
     *   identity-oidc-issuer: ${example.identities[0]&#46;oidcs[0].issuer}
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getCluster.
     * @return A collection of values returned by getCluster.
     */
    public suspend fun getCluster(argument: GetClusterPlainArgs): GetClusterResult =
        getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())

    /**
     * @see [getCluster].
     * @param name Name of the cluster.
     * @param tags Key-value map of resource tags.
     * @return A collection of values returned by getCluster.
     */
    public suspend fun getCluster(name: String, tags: Map<String, String>? = null): GetClusterResult {
        val argument = GetClusterPlainArgs(
            name = name,
            tags = tags,
        )
        return getClusterResultToKotlin(getClusterPlain(argument.toJava()).await())
    }

    /**
     * @see [getCluster].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;eks&#46;kotlin&#46;inputs&#46;GetClusterPlainArgs].
     * @return A collection of values returned by getCluster.
     */
    public suspend fun getCluster(argument: suspend GetClusterPlainArgsBuilder.() -> Unit): GetClusterResult {
        val builder = GetClusterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterResultToKotlin(getClusterPlain(builtArgument.toJava()).await())
    }

    /**
     * Get an authentication token to communicate with an EKS cluster.
     * Uses IAM credentials from the AWS provider to generate a temporary token that is compatible with
     * [AWS IAM Authenticator](https://github.com/kubernetes-sigs/aws-iam-authenticator) authentication.
     * This can be used to authenticate to an EKS cluster or to a cluster that has the AWS IAM Authenticator
     * server configured.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.eks.getCluster({
     *     name: "example",
     * });
     * const exampleGetClusterAuth = aws.eks.getClusterAuth({
     *     name: "example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.eks.get_cluster(name="example")
     * example_get_cluster_auth = aws.eks.get_cluster_auth(name="example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Eks.GetCluster.Invoke(new()
     *     {
     *         Name = "example",
     *     });
     *     var exampleGetClusterAuth = Aws.Eks.GetClusterAuth.Invoke(new()
     *     {
     *         Name = "example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/eks"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := eks.LookupCluster(ctx, &eks.LookupClusterArgs{
     * 			Name: "example",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		_, err = eks.GetClusterAuth(ctx, &eks.GetClusterAuthArgs{
     * 			Name: "example",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.eks.EksFunctions;
     * import com.pulumi.aws.eks.inputs.GetClusterArgs;
     * import com.pulumi.aws.eks.inputs.GetClusterAuthArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EksFunctions.getCluster(GetClusterArgs.builder()
     *             .name("example")
     *             .build());
     *         final var exampleGetClusterAuth = EksFunctions.getClusterAuth(GetClusterAuthArgs.builder()
     *             .name("example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:eks:getCluster
     *       Arguments:
     *         name: example
     *   exampleGetClusterAuth:
     *     fn::invoke:
     *       Function: aws:eks:getClusterAuth
     *       Arguments:
     *         name: example
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getClusterAuth.
     * @return A collection of values returned by getClusterAuth.
     */
    public suspend fun getClusterAuth(argument: GetClusterAuthPlainArgs): GetClusterAuthResult =
        getClusterAuthResultToKotlin(getClusterAuthPlain(argument.toJava()).await())

    /**
     * @see [getClusterAuth].
     * @param name Name of the cluster
     * @return A collection of values returned by getClusterAuth.
     */
    public suspend fun getClusterAuth(name: String): GetClusterAuthResult {
        val argument = GetClusterAuthPlainArgs(
            name = name,
        )
        return getClusterAuthResultToKotlin(getClusterAuthPlain(argument.toJava()).await())
    }

    /**
     * @see [getClusterAuth].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;eks&#46;kotlin&#46;inputs&#46;GetClusterAuthPlainArgs].
     * @return A collection of values returned by getClusterAuth.
     */
    public suspend fun getClusterAuth(argument: suspend GetClusterAuthPlainArgsBuilder.() -> Unit): GetClusterAuthResult {
        val builder = GetClusterAuthPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getClusterAuthResultToKotlin(getClusterAuthPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve EKS Clusters list
     * @param argument Retrieve EKS Clusters list
     * @return A collection of values returned by getClusters.
     */
    public suspend fun getClusters(): GetClustersResult =
        getClustersResultToKotlin(getClustersPlain().await())

    /**
     * Retrieve information about an EKS Node Group.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.eks.getNodeGroup({
     *     clusterName: "example",
     *     nodeGroupName: "example",
     * });
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.eks.get_node_group(cluster_name="example",
     *     node_group_name="example")
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Eks.GetNodeGroup.Invoke(new()
     *     {
     *         ClusterName = "example",
     *         NodeGroupName = "example",
     *     });
     * });
     * ```
     * ```go
     * package main
     * import (
     * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/eks"
     * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
     * )
     * func main() {
     * 	pulumi.Run(func(ctx *pulumi.Context) error {
     * 		_, err := eks.LookupNodeGroup(ctx, &eks.LookupNodeGroupArgs{
     * 			ClusterName:   "example",
     * 			NodeGroupName: "example",
     * 		}, nil)
     * 		if err != nil {
     * 			return err
     * 		}
     * 		return nil
     * 	})
     * }
     * ```
     * ```java
     * package generated_program;
     * import com.pulumi.Context;
     * import com.pulumi.Pulumi;
     * import com.pulumi.core.Output;
     * import com.pulumi.aws.eks.EksFunctions;
     * import com.pulumi.aws.eks.inputs.GetNodeGroupArgs;
     * import java.util.List;
     * import java.util.ArrayList;
     * import java.util.Map;
     * import java.io.File;
     * import java.nio.file.Files;
     * import java.nio.file.Paths;
     * public class App {
     *     public static void main(String[] args) {
     *         Pulumi.run(App::stack);
     *     }
     *     public static void stack(Context ctx) {
     *         final var example = EksFunctions.getNodeGroup(GetNodeGroupArgs.builder()
     *             .clusterName("example")
     *             .nodeGroupName("example")
     *             .build());
     *     }
     * }
     * ```
     * ```yaml
     * variables:
     *   example:
     *     fn::invoke:
     *       Function: aws:eks:getNodeGroup
     *       Arguments:
     *         clusterName: example
     *         nodeGroupName: example
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getNodeGroup.
     * @return A collection of values returned by getNodeGroup.
     */
    public suspend fun getNodeGroup(argument: GetNodeGroupPlainArgs): GetNodeGroupResult =
        getNodeGroupResultToKotlin(getNodeGroupPlain(argument.toJava()).await())

    /**
     * @see [getNodeGroup].
     * @param clusterName Name of the cluster.
     * @param nodeGroupName Name of the node group.
     * @param tags Key-value map of resource tags.
     * @return A collection of values returned by getNodeGroup.
     */
    public suspend fun getNodeGroup(
        clusterName: String,
        nodeGroupName: String,
        tags: Map<String, String>? = null,
    ): GetNodeGroupResult {
        val argument = GetNodeGroupPlainArgs(
            clusterName = clusterName,
            nodeGroupName = nodeGroupName,
            tags = tags,
        )
        return getNodeGroupResultToKotlin(getNodeGroupPlain(argument.toJava()).await())
    }

    /**
     * @see [getNodeGroup].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;eks&#46;kotlin&#46;inputs&#46;GetNodeGroupPlainArgs].
     * @return A collection of values returned by getNodeGroup.
     */
    public suspend fun getNodeGroup(argument: suspend GetNodeGroupPlainArgsBuilder.() -> Unit): GetNodeGroupResult {
        val builder = GetNodeGroupPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNodeGroupResultToKotlin(getNodeGroupPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieve the EKS Node Groups associated with a named EKS cluster. This will allow you to pass a list of Node Group names to other resources.
     * ## Example Usage
     * <!--Start PulumiCodeChooser -->
     * ```typescript
     * import * as pulumi from "@pulumi/pulumi";
     * import * as aws from "@pulumi/aws";
     * const example = aws.eks.getNodeGroups({
     *     clusterName: "example",
     * });
     * const exampleGetNodeGroup = example.then(example => .reduce((__obj, [, ]) => ({ &#46;&#46;&#46;__obj, [__key]: aws.eks.getNodeGroup({
     *     clusterName: "example",
     *     nodeGroupName: __value,
     * }) })));
     * ```
     * ```python
     * import pulumi
     * import pulumi_aws as aws
     * example = aws.eks.get_node_groups(cluster_name="example")
     * example_get_node_group = {__key: aws.eks.get_node_group(cluster_name="example",
     *     node_group_name=__value) for __key, __value in example.names}
     * ```
     * ```csharp
     * using System.Collections.Generic;
     * using System.Linq;
     * using Pulumi;
     * using Aws = Pulumi.Aws;
     * return await Deployment.RunAsync(() =>
     * {
     *     var example = Aws.Eks.GetNodeGroups.Invoke(new()
     *     {
     *         ClusterName = "example",
     *     });
     *     var exampleGetNodeGroup = ;
     * });
     * ```
     * <!--End PulumiCodeChooser -->
     * @param argument A collection of arguments for invoking getNodeGroups.
     * @return A collection of values returned by getNodeGroups.
     */
    public suspend fun getNodeGroups(argument: GetNodeGroupsPlainArgs): GetNodeGroupsResult =
        getNodeGroupsResultToKotlin(getNodeGroupsPlain(argument.toJava()).await())

    /**
     * @see [getNodeGroups].
     * @param clusterName Name of the cluster.
     * @return A collection of values returned by getNodeGroups.
     */
    public suspend fun getNodeGroups(clusterName: String): GetNodeGroupsResult {
        val argument = GetNodeGroupsPlainArgs(
            clusterName = clusterName,
        )
        return getNodeGroupsResultToKotlin(getNodeGroupsPlain(argument.toJava()).await())
    }

    /**
     * @see [getNodeGroups].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;eks&#46;kotlin&#46;inputs&#46;GetNodeGroupsPlainArgs].
     * @return A collection of values returned by getNodeGroups.
     */
    public suspend fun getNodeGroups(argument: suspend GetNodeGroupsPlainArgsBuilder.() -> Unit): GetNodeGroupsResult {
        val builder = GetNodeGroupsPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getNodeGroupsResultToKotlin(getNodeGroupsPlain(builtArgument.toJava()).await())
    }
}
