@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin

import com.pulumi.aws.eks.kotlin.outputs.FargateProfileSelector
import com.pulumi.aws.eks.kotlin.outputs.FargateProfileSelector.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [FargateProfile].
 */
@PulumiTagMarker
public class FargateProfileResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FargateProfileArgs = FargateProfileArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FargateProfileArgsBuilder.() -> Unit) {
        val builder = FargateProfileArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): FargateProfile {
        val builtJavaResource = com.pulumi.aws.eks.FargateProfile(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FargateProfile(builtJavaResource)
    }
}

/**
 * Manages an EKS Fargate Profile.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.eks.FargateProfile("example", {
 *     clusterName: exampleAwsEksCluster.name,
 *     fargateProfileName: "example",
 *     podExecutionRoleArn: exampleAwsIamRole.arn,
 *     subnetIds: exampleAwsSubnet.map(__item => __item.id),
 *     selectors: [{
 *         namespace: "example",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.eks.FargateProfile("example",
 *     cluster_name=example_aws_eks_cluster["name"],
 *     fargate_profile_name="example",
 *     pod_execution_role_arn=example_aws_iam_role["arn"],
 *     subnet_ids=[__item["id"] for __item in example_aws_subnet],
 *     selectors=[{
 *         "namespace": "example",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Eks.FargateProfile("example", new()
 *     {
 *         ClusterName = exampleAwsEksCluster.Name,
 *         FargateProfileName = "example",
 *         PodExecutionRoleArn = exampleAwsIamRole.Arn,
 *         SubnetIds = exampleAwsSubnet.Select(__item => __item.Id).ToList(),
 *         Selectors = new[]
 *         {
 *             new Aws.Eks.Inputs.FargateProfileSelectorArgs
 *             {
 *                 Namespace = "example",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/eks"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * var splat0 []interface{}
 * for _, val0 := range exampleAwsSubnet {
 * splat0 = append(splat0, val0.Id)
 * }
 * _, err := eks.NewFargateProfile(ctx, "example", &eks.FargateProfileArgs{
 * ClusterName: pulumi.Any(exampleAwsEksCluster.Name),
 * FargateProfileName: pulumi.String("example"),
 * PodExecutionRoleArn: pulumi.Any(exampleAwsIamRole.Arn),
 * SubnetIds: toPulumiArray(splat0),
 * Selectors: eks.FargateProfileSelectorArray{
 * &eks.FargateProfileSelectorArgs{
 * Namespace: pulumi.String("example"),
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * func toPulumiArray(arr []) pulumi.Array {
 * var pulumiArr pulumi.Array
 * for _, v := range arr {
 * pulumiArr = append(pulumiArr, pulumi.(v))
 * }
 * return pulumiArr
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.eks.FargateProfile;
 * import com.pulumi.aws.eks.FargateProfileArgs;
 * import com.pulumi.aws.eks.inputs.FargateProfileSelectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FargateProfile("example", FargateProfileArgs.builder()
 *             .clusterName(exampleAwsEksCluster.name())
 *             .fargateProfileName("example")
 *             .podExecutionRoleArn(exampleAwsIamRole.arn())
 *             .subnetIds(exampleAwsSubnet.stream().map(element -> element.id()).collect(toList()))
 *             .selectors(FargateProfileSelectorArgs.builder()
 *                 .namespace("example")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Example IAM Role for EKS Fargate Profile
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.iam.Role("example", {
 *     name: "eks-fargate-profile-example",
 *     assumeRolePolicy: JSON.stringify({
 *         Statement: [{
 *             Action: "sts:AssumeRole",
 *             Effect: "Allow",
 *             Principal: {
 *                 Service: "eks-fargate-pods.amazonaws.com",
 *             },
 *         }],
 *         Version: "2012-10-17",
 *     }),
 * });
 * const example_AmazonEKSFargatePodExecutionRolePolicy = new aws.iam.RolePolicyAttachment("example-AmazonEKSFargatePodExecutionRolePolicy", {
 *     policyArn: "arn:aws:iam::aws:policy/AmazonEKSFargatePodExecutionRolePolicy",
 *     role: example.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example = aws.iam.Role("example",
 *     name="eks-fargate-profile-example",
 *     assume_role_policy=json.dumps({
 *         "Statement": [{
 *             "Action": "sts:AssumeRole",
 *             "Effect": "Allow",
 *             "Principal": {
 *                 "Service": "eks-fargate-pods.amazonaws.com",
 *             },
 *         }],
 *         "Version": "2012-10-17",
 *     }))
 * example__amazon_eks_fargate_pod_execution_role_policy = aws.iam.RolePolicyAttachment("example-AmazonEKSFargatePodExecutionRolePolicy",
 *     policy_arn="arn:aws:iam::aws:policy/AmazonEKSFargatePodExecutionRolePolicy",
 *     role=example.name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Iam.Role("example", new()
 *     {
 *         Name = "eks-fargate-profile-example",
 *         AssumeRolePolicy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Action"] = "sts:AssumeRole",
 *                     ["Effect"] = "Allow",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["Service"] = "eks-fargate-pods.amazonaws.com",
 *                     },
 *                 },
 *             },
 *             ["Version"] = "2012-10-17",
 *         }),
 *     });
 *     var example_AmazonEKSFargatePodExecutionRolePolicy = new Aws.Iam.RolePolicyAttachment("example-AmazonEKSFargatePodExecutionRolePolicy", new()
 *     {
 *         PolicyArn = "arn:aws:iam::aws:policy/AmazonEKSFargatePodExecutionRolePolicy",
 *         Role = example.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Action": "sts:AssumeRole",
 * 					"Effect": "Allow",
 * 					"Principal": map[string]interface{}{
 * 						"Service": "eks-fargate-pods.amazonaws.com",
 * 					},
 * 				},
 * 			},
 * 			"Version": "2012-10-17",
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		example, err := iam.NewRole(ctx, "example", &iam.RoleArgs{
 * 			Name:             pulumi.String("eks-fargate-profile-example"),
 * 			AssumeRolePolicy: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewRolePolicyAttachment(ctx, "example-AmazonEKSFargatePodExecutionRolePolicy", &iam.RolePolicyAttachmentArgs{
 * 			PolicyArn: pulumi.String("arn:aws:iam::aws:policy/AmazonEKSFargatePodExecutionRolePolicy"),
 * 			Role:      example.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Role("example", RoleArgs.builder()
 *             .name("eks-fargate-profile-example")
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "eks-fargate-pods.amazonaws.com")
 *                         ))
 *                     ))),
 *                     jsonProperty("Version", "2012-10-17")
 *                 )))
 *             .build());
 *         var example_AmazonEKSFargatePodExecutionRolePolicy = new RolePolicyAttachment("example-AmazonEKSFargatePodExecutionRolePolicy", RolePolicyAttachmentArgs.builder()
 *             .policyArn("arn:aws:iam::aws:policy/AmazonEKSFargatePodExecutionRolePolicy")
 *             .role(example.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iam:Role
 *     properties:
 *       name: eks-fargate-profile-example
 *       assumeRolePolicy:
 *         fn::toJSON:
 *           Statement:
 *             - Action: sts:AssumeRole
 *               Effect: Allow
 *               Principal:
 *                 Service: eks-fargate-pods.amazonaws.com
 *           Version: 2012-10-17
 *   example-AmazonEKSFargatePodExecutionRolePolicy:
 *     type: aws:iam:RolePolicyAttachment
 *     properties:
 *       policyArn: arn:aws:iam::aws:policy/AmazonEKSFargatePodExecutionRolePolicy
 *       role: ${example.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EKS Fargate Profiles using the `cluster_name` and `fargate_profile_name` separated by a colon (`:`). For example:
 * ```sh
 * $ pulumi import aws:eks/fargateProfile:FargateProfile my_fargate_profile my_cluster:my_fargate_profile
 * ```
 */
public class FargateProfile internal constructor(
    override val javaResource: com.pulumi.aws.eks.FargateProfile,
) : KotlinCustomResource(javaResource, FargateProfileMapper) {
    /**
     * Amazon Resource Name (ARN) of the EKS Fargate Profile.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Name of the EKS Cluster.
     */
    public val clusterName: Output<String>
        get() = javaResource.clusterName().applyValue({ args0 -> args0 })

    /**
     * Name of the EKS Fargate Profile.
     */
    public val fargateProfileName: Output<String>
        get() = javaResource.fargateProfileName().applyValue({ args0 -> args0 })

    /**
     * Amazon Resource Name (ARN) of the IAM Role that provides permissions for the EKS Fargate Profile.
     */
    public val podExecutionRoleArn: Output<String>
        get() = javaResource.podExecutionRoleArn().applyValue({ args0 -> args0 })

    /**
     * Configuration block(s) for selecting Kubernetes Pods to execute with this EKS Fargate Profile. Detailed below.
     */
    public val selectors: Output<List<FargateProfileSelector>>
        get() = javaResource.selectors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            })
        })

    /**
     * Status of the EKS Fargate Profile.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Identifiers of private EC2 Subnets to associate with the EKS Fargate Profile. These subnets must have the following resource tag: `kubernetes.io/cluster/CLUSTER_NAME` (where `CLUSTER_NAME` is replaced with the name of the EKS Cluster).
     * The following arguments are optional:
     */
    public val subnetIds: Output<List<String>>?
        get() = javaResource.subnetIds().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object FargateProfileMapper : ResourceMapper<FargateProfile> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.eks.FargateProfile::class == javaResource::class

    override fun map(javaResource: Resource): FargateProfile = FargateProfile(
        javaResource as
            com.pulumi.aws.eks.FargateProfile,
    )
}

/**
 * @see [FargateProfile].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FargateProfile].
 */
public suspend fun fargateProfile(
    name: String,
    block: suspend FargateProfileResourceBuilder.() -> Unit,
): FargateProfile {
    val builder = FargateProfileResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FargateProfile].
 * @param name The _unique_ name of the resulting resource.
 */
public fun fargateProfile(name: String): FargateProfile {
    val builder = FargateProfileResourceBuilder()
    builder.name(name)
    return builder.build()
}
