@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin

import com.pulumi.aws.eks.FargateProfileArgs.builder
import com.pulumi.aws.eks.kotlin.inputs.FargateProfileSelectorArgs
import com.pulumi.aws.eks.kotlin.inputs.FargateProfileSelectorArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an EKS Fargate Profile.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.eks.FargateProfile("example", {
 *     clusterName: exampleAwsEksCluster.name,
 *     fargateProfileName: "example",
 *     podExecutionRoleArn: exampleAwsIamRole.arn,
 *     subnetIds: exampleAwsSubnet.map(__item => __item.id),
 *     selectors: [{
 *         namespace: "example",
 *     }],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.eks.FargateProfile("example",
 *     cluster_name=example_aws_eks_cluster["name"],
 *     fargate_profile_name="example",
 *     pod_execution_role_arn=example_aws_iam_role["arn"],
 *     subnet_ids=[__item["id"] for __item in example_aws_subnet],
 *     selectors=[{
 *         "namespace": "example",
 *     }])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Eks.FargateProfile("example", new()
 *     {
 *         ClusterName = exampleAwsEksCluster.Name,
 *         FargateProfileName = "example",
 *         PodExecutionRoleArn = exampleAwsIamRole.Arn,
 *         SubnetIds = exampleAwsSubnet.Select(__item => __item.Id).ToList(),
 *         Selectors = new[]
 *         {
 *             new Aws.Eks.Inputs.FargateProfileSelectorArgs
 *             {
 *                 Namespace = "example",
 *             },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/eks"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * var splat0 []interface{}
 * for _, val0 := range exampleAwsSubnet {
 * splat0 = append(splat0, val0.Id)
 * }
 * _, err := eks.NewFargateProfile(ctx, "example", &eks.FargateProfileArgs{
 * ClusterName: pulumi.Any(exampleAwsEksCluster.Name),
 * FargateProfileName: pulumi.String("example"),
 * PodExecutionRoleArn: pulumi.Any(exampleAwsIamRole.Arn),
 * SubnetIds: toPulumiArray(splat0),
 * Selectors: eks.FargateProfileSelectorArray{
 * &eks.FargateProfileSelectorArgs{
 * Namespace: pulumi.String("example"),
 * },
 * },
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * func toPulumiArray(arr []) pulumi.Array {
 * var pulumiArr pulumi.Array
 * for _, v := range arr {
 * pulumiArr = append(pulumiArr, pulumi.(v))
 * }
 * return pulumiArr
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.eks.FargateProfile;
 * import com.pulumi.aws.eks.FargateProfileArgs;
 * import com.pulumi.aws.eks.inputs.FargateProfileSelectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new FargateProfile("example", FargateProfileArgs.builder()
 *             .clusterName(exampleAwsEksCluster.name())
 *             .fargateProfileName("example")
 *             .podExecutionRoleArn(exampleAwsIamRole.arn())
 *             .subnetIds(exampleAwsSubnet.stream().map(element -> element.id()).collect(toList()))
 *             .selectors(FargateProfileSelectorArgs.builder()
 *                 .namespace("example")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Example IAM Role for EKS Fargate Profile
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.iam.Role("example", {
 *     name: "eks-fargate-profile-example",
 *     assumeRolePolicy: JSON.stringify({
 *         Statement: [{
 *             Action: "sts:AssumeRole",
 *             Effect: "Allow",
 *             Principal: {
 *                 Service: "eks-fargate-pods.amazonaws.com",
 *             },
 *         }],
 *         Version: "2012-10-17",
 *     }),
 * });
 * const example_AmazonEKSFargatePodExecutionRolePolicy = new aws.iam.RolePolicyAttachment("example-AmazonEKSFargatePodExecutionRolePolicy", {
 *     policyArn: "arn:aws:iam::aws:policy/AmazonEKSFargatePodExecutionRolePolicy",
 *     role: example.name,
 * });
 * ```
 * ```python
 * import pulumi
 * import json
 * import pulumi_aws as aws
 * example = aws.iam.Role("example",
 *     name="eks-fargate-profile-example",
 *     assume_role_policy=json.dumps({
 *         "Statement": [{
 *             "Action": "sts:AssumeRole",
 *             "Effect": "Allow",
 *             "Principal": {
 *                 "Service": "eks-fargate-pods.amazonaws.com",
 *             },
 *         }],
 *         "Version": "2012-10-17",
 *     }))
 * example__amazon_eks_fargate_pod_execution_role_policy = aws.iam.RolePolicyAttachment("example-AmazonEKSFargatePodExecutionRolePolicy",
 *     policy_arn="arn:aws:iam::aws:policy/AmazonEKSFargatePodExecutionRolePolicy",
 *     role=example.name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using System.Text.Json;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Iam.Role("example", new()
 *     {
 *         Name = "eks-fargate-profile-example",
 *         AssumeRolePolicy = JsonSerializer.Serialize(new Dictionary<string, object?>
 *         {
 *             ["Statement"] = new[]
 *             {
 *                 new Dictionary<string, object?>
 *                 {
 *                     ["Action"] = "sts:AssumeRole",
 *                     ["Effect"] = "Allow",
 *                     ["Principal"] = new Dictionary<string, object?>
 *                     {
 *                         ["Service"] = "eks-fargate-pods.amazonaws.com",
 *                     },
 *                 },
 *             },
 *             ["Version"] = "2012-10-17",
 *         }),
 *     });
 *     var example_AmazonEKSFargatePodExecutionRolePolicy = new Aws.Iam.RolePolicyAttachment("example-AmazonEKSFargatePodExecutionRolePolicy", new()
 *     {
 *         PolicyArn = "arn:aws:iam::aws:policy/AmazonEKSFargatePodExecutionRolePolicy",
 *         Role = example.Name,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"encoding/json"
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/iam"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		tmpJSON0, err := json.Marshal(map[string]interface{}{
 * 			"Statement": []map[string]interface{}{
 * 				map[string]interface{}{
 * 					"Action": "sts:AssumeRole",
 * 					"Effect": "Allow",
 * 					"Principal": map[string]interface{}{
 * 						"Service": "eks-fargate-pods.amazonaws.com",
 * 					},
 * 				},
 * 			},
 * 			"Version": "2012-10-17",
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		json0 := string(tmpJSON0)
 * 		example, err := iam.NewRole(ctx, "example", &iam.RoleArgs{
 * 			Name:             pulumi.String("eks-fargate-profile-example"),
 * 			AssumeRolePolicy: pulumi.String(json0),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = iam.NewRolePolicyAttachment(ctx, "example-AmazonEKSFargatePodExecutionRolePolicy", &iam.RolePolicyAttachmentArgs{
 * 			PolicyArn: pulumi.String("arn:aws:iam::aws:policy/AmazonEKSFargatePodExecutionRolePolicy"),
 * 			Role:      example.Name,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.iam.Role;
 * import com.pulumi.aws.iam.RoleArgs;
 * import com.pulumi.aws.iam.RolePolicyAttachment;
 * import com.pulumi.aws.iam.RolePolicyAttachmentArgs;
 * import static com.pulumi.codegen.internal.Serialization.*;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Role("example", RoleArgs.builder()
 *             .name("eks-fargate-profile-example")
 *             .assumeRolePolicy(serializeJson(
 *                 jsonObject(
 *                     jsonProperty("Statement", jsonArray(jsonObject(
 *                         jsonProperty("Action", "sts:AssumeRole"),
 *                         jsonProperty("Effect", "Allow"),
 *                         jsonProperty("Principal", jsonObject(
 *                             jsonProperty("Service", "eks-fargate-pods.amazonaws.com")
 *                         ))
 *                     ))),
 *                     jsonProperty("Version", "2012-10-17")
 *                 )))
 *             .build());
 *         var example_AmazonEKSFargatePodExecutionRolePolicy = new RolePolicyAttachment("example-AmazonEKSFargatePodExecutionRolePolicy", RolePolicyAttachmentArgs.builder()
 *             .policyArn("arn:aws:iam::aws:policy/AmazonEKSFargatePodExecutionRolePolicy")
 *             .role(example.name())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:iam:Role
 *     properties:
 *       name: eks-fargate-profile-example
 *       assumeRolePolicy:
 *         fn::toJSON:
 *           Statement:
 *             - Action: sts:AssumeRole
 *               Effect: Allow
 *               Principal:
 *                 Service: eks-fargate-pods.amazonaws.com
 *           Version: 2012-10-17
 *   example-AmazonEKSFargatePodExecutionRolePolicy:
 *     type: aws:iam:RolePolicyAttachment
 *     properties:
 *       policyArn: arn:aws:iam::aws:policy/AmazonEKSFargatePodExecutionRolePolicy
 *       role: ${example.name}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EKS Fargate Profiles using the `cluster_name` and `fargate_profile_name` separated by a colon (`:`). For example:
 * ```sh
 * $ pulumi import aws:eks/fargateProfile:FargateProfile my_fargate_profile my_cluster:my_fargate_profile
 * ```
 * @property clusterName Name of the EKS Cluster.
 * @property fargateProfileName Name of the EKS Fargate Profile.
 * @property podExecutionRoleArn Amazon Resource Name (ARN) of the IAM Role that provides permissions for the EKS Fargate Profile.
 * @property selectors Configuration block(s) for selecting Kubernetes Pods to execute with this EKS Fargate Profile. Detailed below.
 * @property subnetIds Identifiers of private EC2 Subnets to associate with the EKS Fargate Profile. These subnets must have the following resource tag: `kubernetes.io/cluster/CLUSTER_NAME` (where `CLUSTER_NAME` is replaced with the name of the EKS Cluster).
 * The following arguments are optional:
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class FargateProfileArgs(
    public val clusterName: Output<String>? = null,
    public val fargateProfileName: Output<String>? = null,
    public val podExecutionRoleArn: Output<String>? = null,
    public val selectors: Output<List<FargateProfileSelectorArgs>>? = null,
    public val subnetIds: Output<List<String>>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.eks.FargateProfileArgs> {
    override fun toJava(): com.pulumi.aws.eks.FargateProfileArgs =
        com.pulumi.aws.eks.FargateProfileArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .fargateProfileName(fargateProfileName?.applyValue({ args0 -> args0 }))
            .podExecutionRoleArn(podExecutionRoleArn?.applyValue({ args0 -> args0 }))
            .selectors(
                selectors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [FargateProfileArgs].
 */
@PulumiTagMarker
public class FargateProfileArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var fargateProfileName: Output<String>? = null

    private var podExecutionRoleArn: Output<String>? = null

    private var selectors: Output<List<FargateProfileSelectorArgs>>? = null

    private var subnetIds: Output<List<String>>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of the EKS Cluster.
     */
    @JvmName("tbxibhlycdmacmct")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Name of the EKS Fargate Profile.
     */
    @JvmName("jocwbtvdxfaqtlef")
    public suspend fun fargateProfileName(`value`: Output<String>) {
        this.fargateProfileName = value
    }

    /**
     * @param value Amazon Resource Name (ARN) of the IAM Role that provides permissions for the EKS Fargate Profile.
     */
    @JvmName("dyhlbwrcpbhgmbql")
    public suspend fun podExecutionRoleArn(`value`: Output<String>) {
        this.podExecutionRoleArn = value
    }

    /**
     * @param value Configuration block(s) for selecting Kubernetes Pods to execute with this EKS Fargate Profile. Detailed below.
     */
    @JvmName("fllbmihxneklnicm")
    public suspend fun selectors(`value`: Output<List<FargateProfileSelectorArgs>>) {
        this.selectors = value
    }

    @JvmName("olbxkdowjhwtvaie")
    public suspend fun selectors(vararg values: Output<FargateProfileSelectorArgs>) {
        this.selectors = Output.all(values.asList())
    }

    /**
     * @param values Configuration block(s) for selecting Kubernetes Pods to execute with this EKS Fargate Profile. Detailed below.
     */
    @JvmName("ieoskxqslhdnsenn")
    public suspend fun selectors(values: List<Output<FargateProfileSelectorArgs>>) {
        this.selectors = Output.all(values)
    }

    /**
     * @param value Identifiers of private EC2 Subnets to associate with the EKS Fargate Profile. These subnets must have the following resource tag: `kubernetes.io/cluster/CLUSTER_NAME` (where `CLUSTER_NAME` is replaced with the name of the EKS Cluster).
     * The following arguments are optional:
     */
    @JvmName("uyffrqbvhrnasgnc")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("haxejuupdkkwovry")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values Identifiers of private EC2 Subnets to associate with the EKS Fargate Profile. These subnets must have the following resource tag: `kubernetes.io/cluster/CLUSTER_NAME` (where `CLUSTER_NAME` is replaced with the name of the EKS Cluster).
     * The following arguments are optional:
     */
    @JvmName("huxnaqaqjqroihrv")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("uctquokwsfdoafxy")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the EKS Cluster.
     */
    @JvmName("eqvhavflyxbiwarv")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Name of the EKS Fargate Profile.
     */
    @JvmName("wmwbvlalwvwpfisd")
    public suspend fun fargateProfileName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fargateProfileName = mapped
    }

    /**
     * @param value Amazon Resource Name (ARN) of the IAM Role that provides permissions for the EKS Fargate Profile.
     */
    @JvmName("eoxyccxhkejwxpix")
    public suspend fun podExecutionRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.podExecutionRoleArn = mapped
    }

    /**
     * @param value Configuration block(s) for selecting Kubernetes Pods to execute with this EKS Fargate Profile. Detailed below.
     */
    @JvmName("djjwitvwkyrsgmul")
    public suspend fun selectors(`value`: List<FargateProfileSelectorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.selectors = mapped
    }

    /**
     * @param argument Configuration block(s) for selecting Kubernetes Pods to execute with this EKS Fargate Profile. Detailed below.
     */
    @JvmName("mylnsrdgbwukjsed")
    public suspend fun selectors(argument: List<suspend FargateProfileSelectorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FargateProfileSelectorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.selectors = mapped
    }

    /**
     * @param argument Configuration block(s) for selecting Kubernetes Pods to execute with this EKS Fargate Profile. Detailed below.
     */
    @JvmName("cwstojimvdsrwqan")
    public suspend fun selectors(vararg argument: suspend FargateProfileSelectorArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FargateProfileSelectorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.selectors = mapped
    }

    /**
     * @param argument Configuration block(s) for selecting Kubernetes Pods to execute with this EKS Fargate Profile. Detailed below.
     */
    @JvmName("uufejcdopuabrdqa")
    public suspend fun selectors(argument: suspend FargateProfileSelectorArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(FargateProfileSelectorArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.selectors = mapped
    }

    /**
     * @param values Configuration block(s) for selecting Kubernetes Pods to execute with this EKS Fargate Profile. Detailed below.
     */
    @JvmName("dwraoqtegrgqlwce")
    public suspend fun selectors(vararg values: FargateProfileSelectorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.selectors = mapped
    }

    /**
     * @param value Identifiers of private EC2 Subnets to associate with the EKS Fargate Profile. These subnets must have the following resource tag: `kubernetes.io/cluster/CLUSTER_NAME` (where `CLUSTER_NAME` is replaced with the name of the EKS Cluster).
     * The following arguments are optional:
     */
    @JvmName("strfyhogsnnvemfd")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values Identifiers of private EC2 Subnets to associate with the EKS Fargate Profile. These subnets must have the following resource tag: `kubernetes.io/cluster/CLUSTER_NAME` (where `CLUSTER_NAME` is replaced with the name of the EKS Cluster).
     * The following arguments are optional:
     */
    @JvmName("mmnjmfdryxewiyhy")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ocfknhvixnxsyknq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("goyhipfutuetlswp")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): FargateProfileArgs = FargateProfileArgs(
        clusterName = clusterName,
        fargateProfileName = fargateProfileName,
        podExecutionRoleArn = podExecutionRoleArn,
        selectors = selectors,
        subnetIds = subnetIds,
        tags = tags,
    )
}
