@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin

import com.pulumi.aws.eks.IdentityProviderConfigArgs.builder
import com.pulumi.aws.eks.kotlin.inputs.IdentityProviderConfigOidcArgs
import com.pulumi.aws.eks.kotlin.inputs.IdentityProviderConfigOidcArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an EKS Identity Provider Configuration.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.eks.IdentityProviderConfig("example", {
 *     clusterName: exampleAwsEksCluster.name,
 *     oidc: {
 *         clientId: "your client_id",
 *         identityProviderConfigName: "example",
 *         issuerUrl: "your issuer_url",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.eks.IdentityProviderConfig("example",
 *     cluster_name=example_aws_eks_cluster["name"],
 *     oidc={
 *         "client_id": "your client_id",
 *         "identity_provider_config_name": "example",
 *         "issuer_url": "your issuer_url",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.Eks.IdentityProviderConfig("example", new()
 *     {
 *         ClusterName = exampleAwsEksCluster.Name,
 *         Oidc = new Aws.Eks.Inputs.IdentityProviderConfigOidcArgs
 *         {
 *             ClientId = "your client_id",
 *             IdentityProviderConfigName = "example",
 *             IssuerUrl = "your issuer_url",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/eks"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := eks.NewIdentityProviderConfig(ctx, "example", &eks.IdentityProviderConfigArgs{
 * 			ClusterName: pulumi.Any(exampleAwsEksCluster.Name),
 * 			Oidc: &eks.IdentityProviderConfigOidcArgs{
 * 				ClientId:                   pulumi.String("your client_id"),
 * 				IdentityProviderConfigName: pulumi.String("example"),
 * 				IssuerUrl:                  pulumi.String("your issuer_url"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.eks.IdentityProviderConfig;
 * import com.pulumi.aws.eks.IdentityProviderConfigArgs;
 * import com.pulumi.aws.eks.inputs.IdentityProviderConfigOidcArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new IdentityProviderConfig("example", IdentityProviderConfigArgs.builder()
 *             .clusterName(exampleAwsEksCluster.name())
 *             .oidc(IdentityProviderConfigOidcArgs.builder()
 *                 .clientId("your client_id")
 *                 .identityProviderConfigName("example")
 *                 .issuerUrl("your issuer_url")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:eks:IdentityProviderConfig
 *     properties:
 *       clusterName: ${exampleAwsEksCluster.name}
 *       oidc:
 *         clientId: your client_id
 *         identityProviderConfigName: example
 *         issuerUrl: your issuer_url
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import EKS Identity Provider Configurations using the `cluster_name` and `identity_provider_config_name` separated by a colon (`:`). For example:
 * ```sh
 * $ pulumi import aws:eks/identityProviderConfig:IdentityProviderConfig my_identity_provider_config my_cluster:my_identity_provider_config
 * ```
 * @property clusterName Name of the EKS Cluster.
 * @property oidc Nested attribute containing [OpenID Connect](https://openid.net/connect/) identity provider information for the cluster. Detailed below.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class IdentityProviderConfigArgs(
    public val clusterName: Output<String>? = null,
    public val oidc: Output<IdentityProviderConfigOidcArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.eks.IdentityProviderConfigArgs> {
    override fun toJava(): com.pulumi.aws.eks.IdentityProviderConfigArgs =
        com.pulumi.aws.eks.IdentityProviderConfigArgs.builder()
            .clusterName(clusterName?.applyValue({ args0 -> args0 }))
            .oidc(oidc?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [IdentityProviderConfigArgs].
 */
@PulumiTagMarker
public class IdentityProviderConfigArgsBuilder internal constructor() {
    private var clusterName: Output<String>? = null

    private var oidc: Output<IdentityProviderConfigOidcArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of the EKS Cluster.
     */
    @JvmName("ojgfrfholwyvvrxr")
    public suspend fun clusterName(`value`: Output<String>) {
        this.clusterName = value
    }

    /**
     * @param value Nested attribute containing [OpenID Connect](https://openid.net/connect/) identity provider information for the cluster. Detailed below.
     */
    @JvmName("lbmvtbkqostnuwki")
    public suspend fun oidc(`value`: Output<IdentityProviderConfigOidcArgs>) {
        this.oidc = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mnlftlbnijuaqsxe")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the EKS Cluster.
     */
    @JvmName("qdeswxufvicuvhuh")
    public suspend fun clusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterName = mapped
    }

    /**
     * @param value Nested attribute containing [OpenID Connect](https://openid.net/connect/) identity provider information for the cluster. Detailed below.
     */
    @JvmName("bxfipxfvbbptibkh")
    public suspend fun oidc(`value`: IdentityProviderConfigOidcArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.oidc = mapped
    }

    /**
     * @param argument Nested attribute containing [OpenID Connect](https://openid.net/connect/) identity provider information for the cluster. Detailed below.
     */
    @JvmName("kxrjokvvdpnlfvvh")
    public suspend fun oidc(argument: suspend IdentityProviderConfigOidcArgsBuilder.() -> Unit) {
        val toBeMapped = IdentityProviderConfigOidcArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.oidc = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ujfswjkwdcoeowtj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("tsrxmgoueiirsqtm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): IdentityProviderConfigArgs = IdentityProviderConfigArgs(
        clusterName = clusterName,
        oidc = oidc,
        tags = tags,
    )
}
