@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.inputs

import com.pulumi.aws.eks.inputs.AccessPolicyAssociationAccessScopeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property namespaces The namespaces to which the access scope applies when type is namespace.
 * @property type Valid values are `namespace` or `cluster`.
 */
public data class AccessPolicyAssociationAccessScopeArgs(
    public val namespaces: Output<List<String>>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.eks.inputs.AccessPolicyAssociationAccessScopeArgs> {
    override fun toJava(): com.pulumi.aws.eks.inputs.AccessPolicyAssociationAccessScopeArgs =
        com.pulumi.aws.eks.inputs.AccessPolicyAssociationAccessScopeArgs.builder()
            .namespaces(namespaces?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AccessPolicyAssociationAccessScopeArgs].
 */
@PulumiTagMarker
public class AccessPolicyAssociationAccessScopeArgsBuilder internal constructor() {
    private var namespaces: Output<List<String>>? = null

    private var type: Output<String>? = null

    /**
     * @param value The namespaces to which the access scope applies when type is namespace.
     */
    @JvmName("kysqvcversavhote")
    public suspend fun namespaces(`value`: Output<List<String>>) {
        this.namespaces = value
    }

    @JvmName("ctljrggkbtqqudmg")
    public suspend fun namespaces(vararg values: Output<String>) {
        this.namespaces = Output.all(values.asList())
    }

    /**
     * @param values The namespaces to which the access scope applies when type is namespace.
     */
    @JvmName("enhsskhchnijhkrv")
    public suspend fun namespaces(values: List<Output<String>>) {
        this.namespaces = Output.all(values)
    }

    /**
     * @param value Valid values are `namespace` or `cluster`.
     */
    @JvmName("jihvenxcrlcdrtgm")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The namespaces to which the access scope applies when type is namespace.
     */
    @JvmName("vxfesaxcixkykvhu")
    public suspend fun namespaces(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namespaces = mapped
    }

    /**
     * @param values The namespaces to which the access scope applies when type is namespace.
     */
    @JvmName("yjhqyreuomlekqkp")
    public suspend fun namespaces(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.namespaces = mapped
    }

    /**
     * @param value Valid values are `namespace` or `cluster`.
     */
    @JvmName("sqcimluwouqfpjlf")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AccessPolicyAssociationAccessScopeArgs =
        AccessPolicyAssociationAccessScopeArgs(
            namespaces = namespaces,
            type = type ?: throw PulumiNullFieldException("type"),
        )
}
