@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.inputs

import com.pulumi.aws.eks.inputs.ClusterAccessConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property authenticationMode The authentication mode for the cluster. Valid values are `CONFIG_MAP`, `API` or `API_AND_CONFIG_MAP`
 * @property bootstrapClusterCreatorAdminPermissions Whether or not to bootstrap the access config values to the cluster. Default is `false`.
 */
public data class ClusterAccessConfigArgs(
    public val authenticationMode: Output<String>? = null,
    public val bootstrapClusterCreatorAdminPermissions: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.aws.eks.inputs.ClusterAccessConfigArgs> {
    override fun toJava(): com.pulumi.aws.eks.inputs.ClusterAccessConfigArgs =
        com.pulumi.aws.eks.inputs.ClusterAccessConfigArgs.builder()
            .authenticationMode(authenticationMode?.applyValue({ args0 -> args0 }))
            .bootstrapClusterCreatorAdminPermissions(
                bootstrapClusterCreatorAdminPermissions?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [ClusterAccessConfigArgs].
 */
@PulumiTagMarker
public class ClusterAccessConfigArgsBuilder internal constructor() {
    private var authenticationMode: Output<String>? = null

    private var bootstrapClusterCreatorAdminPermissions: Output<Boolean>? = null

    /**
     * @param value The authentication mode for the cluster. Valid values are `CONFIG_MAP`, `API` or `API_AND_CONFIG_MAP`
     */
    @JvmName("lkgxsoktvpdotqws")
    public suspend fun authenticationMode(`value`: Output<String>) {
        this.authenticationMode = value
    }

    /**
     * @param value Whether or not to bootstrap the access config values to the cluster. Default is `false`.
     */
    @JvmName("krbbihlqhhipcrdf")
    public suspend fun bootstrapClusterCreatorAdminPermissions(`value`: Output<Boolean>) {
        this.bootstrapClusterCreatorAdminPermissions = value
    }

    /**
     * @param value The authentication mode for the cluster. Valid values are `CONFIG_MAP`, `API` or `API_AND_CONFIG_MAP`
     */
    @JvmName("gbkvdvxwjpscrnlx")
    public suspend fun authenticationMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationMode = mapped
    }

    /**
     * @param value Whether or not to bootstrap the access config values to the cluster. Default is `false`.
     */
    @JvmName("lutfbaoxqpabdcrs")
    public suspend fun bootstrapClusterCreatorAdminPermissions(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bootstrapClusterCreatorAdminPermissions = mapped
    }

    internal fun build(): ClusterAccessConfigArgs = ClusterAccessConfigArgs(
        authenticationMode = authenticationMode,
        bootstrapClusterCreatorAdminPermissions = bootstrapClusterCreatorAdminPermissions,
    )
}
