@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.inputs

import com.pulumi.aws.eks.inputs.ClusterEncryptionConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property provider Configuration block with provider for encryption. Detailed below.
 * @property resources List of strings with resources to be encrypted. Valid values: `secrets`.
 */
public data class ClusterEncryptionConfigArgs(
    public val provider: Output<ClusterEncryptionConfigProviderArgs>,
    public val resources: Output<List<String>>,
) : ConvertibleToJava<com.pulumi.aws.eks.inputs.ClusterEncryptionConfigArgs> {
    override fun toJava(): com.pulumi.aws.eks.inputs.ClusterEncryptionConfigArgs =
        com.pulumi.aws.eks.inputs.ClusterEncryptionConfigArgs.builder()
            .provider(provider.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resources(resources.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ClusterEncryptionConfigArgs].
 */
@PulumiTagMarker
public class ClusterEncryptionConfigArgsBuilder internal constructor() {
    private var provider: Output<ClusterEncryptionConfigProviderArgs>? = null

    private var resources: Output<List<String>>? = null

    /**
     * @param value Configuration block with provider for encryption. Detailed below.
     */
    @JvmName("fawmchlxmyonvrol")
    public suspend fun provider(`value`: Output<ClusterEncryptionConfigProviderArgs>) {
        this.provider = value
    }

    /**
     * @param value List of strings with resources to be encrypted. Valid values: `secrets`.
     */
    @JvmName("jwholqjenhlfwljs")
    public suspend fun resources(`value`: Output<List<String>>) {
        this.resources = value
    }

    @JvmName("bgqdorndbsudnwks")
    public suspend fun resources(vararg values: Output<String>) {
        this.resources = Output.all(values.asList())
    }

    /**
     * @param values List of strings with resources to be encrypted. Valid values: `secrets`.
     */
    @JvmName("frkffqxlvrbarjek")
    public suspend fun resources(values: List<Output<String>>) {
        this.resources = Output.all(values)
    }

    /**
     * @param value Configuration block with provider for encryption. Detailed below.
     */
    @JvmName("dkkceagsugloaome")
    public suspend fun provider(`value`: ClusterEncryptionConfigProviderArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.provider = mapped
    }

    /**
     * @param argument Configuration block with provider for encryption. Detailed below.
     */
    @JvmName("dywgsjlnnmbmsmbw")
    public suspend fun provider(argument: suspend ClusterEncryptionConfigProviderArgsBuilder.() -> Unit) {
        val toBeMapped = ClusterEncryptionConfigProviderArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.provider = mapped
    }

    /**
     * @param value List of strings with resources to be encrypted. Valid values: `secrets`.
     */
    @JvmName("dwaijplnpfrtlbcg")
    public suspend fun resources(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    /**
     * @param values List of strings with resources to be encrypted. Valid values: `secrets`.
     */
    @JvmName("kjkdupidrnjikkkr")
    public suspend fun resources(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.resources = mapped
    }

    internal fun build(): ClusterEncryptionConfigArgs = ClusterEncryptionConfigArgs(
        provider = provider ?: throw PulumiNullFieldException("provider"),
        resources = resources ?: throw PulumiNullFieldException("resources"),
    )
}
