@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.inputs

import com.pulumi.aws.eks.inputs.ClusterEncryptionConfigProviderArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property keyArn ARN of the Key Management Service (KMS) customer master key (CMK). The CMK must be symmetric, created in the same region as the cluster, and if the CMK was created in a different account, the user must have access to the CMK. For more information, see [Allowing Users in Other Accounts to Use a CMK in the AWS Key Management Service Developer Guide](https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-modifying-external-accounts.html).
 */
public data class ClusterEncryptionConfigProviderArgs(
    public val keyArn: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.eks.inputs.ClusterEncryptionConfigProviderArgs> {
    override fun toJava(): com.pulumi.aws.eks.inputs.ClusterEncryptionConfigProviderArgs =
        com.pulumi.aws.eks.inputs.ClusterEncryptionConfigProviderArgs.builder()
            .keyArn(keyArn.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterEncryptionConfigProviderArgs].
 */
@PulumiTagMarker
public class ClusterEncryptionConfigProviderArgsBuilder internal constructor() {
    private var keyArn: Output<String>? = null

    /**
     * @param value ARN of the Key Management Service (KMS) customer master key (CMK). The CMK must be symmetric, created in the same region as the cluster, and if the CMK was created in a different account, the user must have access to the CMK. For more information, see [Allowing Users in Other Accounts to Use a CMK in the AWS Key Management Service Developer Guide](https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-modifying-external-accounts.html).
     */
    @JvmName("bebbledoerfkdbeh")
    public suspend fun keyArn(`value`: Output<String>) {
        this.keyArn = value
    }

    /**
     * @param value ARN of the Key Management Service (KMS) customer master key (CMK). The CMK must be symmetric, created in the same region as the cluster, and if the CMK was created in a different account, the user must have access to the CMK. For more information, see [Allowing Users in Other Accounts to Use a CMK in the AWS Key Management Service Developer Guide](https://docs.aws.amazon.com/kms/latest/developerguide/key-policy-modifying-external-accounts.html).
     */
    @JvmName("ukpklglqsmdliryp")
    public suspend fun keyArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyArn = mapped
    }

    internal fun build(): ClusterEncryptionConfigProviderArgs = ClusterEncryptionConfigProviderArgs(
        keyArn = keyArn ?: throw PulumiNullFieldException("keyArn"),
    )
}
