@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.inputs

import com.pulumi.aws.eks.inputs.ClusterOutpostConfigControlPlanePlacementArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property groupName The name of the placement group for the Kubernetes control plane instances. This setting can't be changed after cluster creation.
 */
public data class ClusterOutpostConfigControlPlanePlacementArgs(
    public val groupName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.eks.inputs.ClusterOutpostConfigControlPlanePlacementArgs> {
    override fun toJava(): com.pulumi.aws.eks.inputs.ClusterOutpostConfigControlPlanePlacementArgs =
        com.pulumi.aws.eks.inputs.ClusterOutpostConfigControlPlanePlacementArgs.builder()
            .groupName(groupName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterOutpostConfigControlPlanePlacementArgs].
 */
@PulumiTagMarker
public class ClusterOutpostConfigControlPlanePlacementArgsBuilder internal constructor() {
    private var groupName: Output<String>? = null

    /**
     * @param value The name of the placement group for the Kubernetes control plane instances. This setting can't be changed after cluster creation.
     */
    @JvmName("wmxakbrbypwuunny")
    public suspend fun groupName(`value`: Output<String>) {
        this.groupName = value
    }

    /**
     * @param value The name of the placement group for the Kubernetes control plane instances. This setting can't be changed after cluster creation.
     */
    @JvmName("ltvgukejqcskrfid")
    public suspend fun groupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupName = mapped
    }

    internal fun build(): ClusterOutpostConfigControlPlanePlacementArgs =
        ClusterOutpostConfigControlPlanePlacementArgs(
            groupName = groupName ?: throw PulumiNullFieldException("groupName"),
        )
}
