@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.inputs

import com.pulumi.aws.eks.inputs.ClusterUpgradePolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property supportType Support type to use for the cluster. If the cluster is set to `EXTENDED`, it will enter extended support at the end of standard support. If the cluster is set to `STANDARD`, it will be automatically upgraded at the end of standard support. Valid values are `EXTENDED`, `STANDARD`
 */
public data class ClusterUpgradePolicyArgs(
    public val supportType: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.eks.inputs.ClusterUpgradePolicyArgs> {
    override fun toJava(): com.pulumi.aws.eks.inputs.ClusterUpgradePolicyArgs =
        com.pulumi.aws.eks.inputs.ClusterUpgradePolicyArgs.builder()
            .supportType(supportType?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterUpgradePolicyArgs].
 */
@PulumiTagMarker
public class ClusterUpgradePolicyArgsBuilder internal constructor() {
    private var supportType: Output<String>? = null

    /**
     * @param value Support type to use for the cluster. If the cluster is set to `EXTENDED`, it will enter extended support at the end of standard support. If the cluster is set to `STANDARD`, it will be automatically upgraded at the end of standard support. Valid values are `EXTENDED`, `STANDARD`
     */
    @JvmName("ylwgaciatvoepoto")
    public suspend fun supportType(`value`: Output<String>) {
        this.supportType = value
    }

    /**
     * @param value Support type to use for the cluster. If the cluster is set to `EXTENDED`, it will enter extended support at the end of standard support. If the cluster is set to `STANDARD`, it will be automatically upgraded at the end of standard support. Valid values are `EXTENDED`, `STANDARD`
     */
    @JvmName("nlpxidjbqlmhenxq")
    public suspend fun supportType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.supportType = mapped
    }

    internal fun build(): ClusterUpgradePolicyArgs = ClusterUpgradePolicyArgs(
        supportType = supportType,
    )
}
