@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.inputs

import com.pulumi.aws.eks.inputs.ClusterVpcConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property clusterSecurityGroupId Cluster security group that was created by Amazon EKS for the cluster. Managed node groups use this security group for control-plane-to-data-plane communication.
 * @property endpointPrivateAccess Whether the Amazon EKS private API server endpoint is enabled. Default is `false`.
 * @property endpointPublicAccess Whether the Amazon EKS public API server endpoint is enabled. Default is `true`.
 * @property publicAccessCidrs List of CIDR blocks. Indicates which CIDR blocks can access the Amazon EKS public API server endpoint when enabled. EKS defaults this to a list with `0.0.0.0/0`. The provider will only perform drift detection of its value when present in a configuration.
 * @property securityGroupIds List of security group IDs for the cross-account elastic network interfaces that Amazon EKS creates to use to allow communication between your worker nodes and the Kubernetes control plane.
 * @property subnetIds List of subnet IDs. Must be in at least two different availability zones. Amazon EKS creates cross-account elastic network interfaces in these subnets to allow communication between your worker nodes and the Kubernetes control plane.
 * @property vpcId ID of the VPC associated with your cluster.
 */
public data class ClusterVpcConfigArgs(
    public val clusterSecurityGroupId: Output<String>? = null,
    public val endpointPrivateAccess: Output<Boolean>? = null,
    public val endpointPublicAccess: Output<Boolean>? = null,
    public val publicAccessCidrs: Output<List<String>>? = null,
    public val securityGroupIds: Output<List<String>>? = null,
    public val subnetIds: Output<List<String>>,
    public val vpcId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.eks.inputs.ClusterVpcConfigArgs> {
    override fun toJava(): com.pulumi.aws.eks.inputs.ClusterVpcConfigArgs =
        com.pulumi.aws.eks.inputs.ClusterVpcConfigArgs.builder()
            .clusterSecurityGroupId(clusterSecurityGroupId?.applyValue({ args0 -> args0 }))
            .endpointPrivateAccess(endpointPrivateAccess?.applyValue({ args0 -> args0 }))
            .endpointPublicAccess(endpointPublicAccess?.applyValue({ args0 -> args0 }))
            .publicAccessCidrs(publicAccessCidrs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetIds(subnetIds.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterVpcConfigArgs].
 */
@PulumiTagMarker
public class ClusterVpcConfigArgsBuilder internal constructor() {
    private var clusterSecurityGroupId: Output<String>? = null

    private var endpointPrivateAccess: Output<Boolean>? = null

    private var endpointPublicAccess: Output<Boolean>? = null

    private var publicAccessCidrs: Output<List<String>>? = null

    private var securityGroupIds: Output<List<String>>? = null

    private var subnetIds: Output<List<String>>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value Cluster security group that was created by Amazon EKS for the cluster. Managed node groups use this security group for control-plane-to-data-plane communication.
     */
    @JvmName("fcshsedirarwgexi")
    public suspend fun clusterSecurityGroupId(`value`: Output<String>) {
        this.clusterSecurityGroupId = value
    }

    /**
     * @param value Whether the Amazon EKS private API server endpoint is enabled. Default is `false`.
     */
    @JvmName("gabrdwpibtrnfppm")
    public suspend fun endpointPrivateAccess(`value`: Output<Boolean>) {
        this.endpointPrivateAccess = value
    }

    /**
     * @param value Whether the Amazon EKS public API server endpoint is enabled. Default is `true`.
     */
    @JvmName("bmwaarhmclxdcxjc")
    public suspend fun endpointPublicAccess(`value`: Output<Boolean>) {
        this.endpointPublicAccess = value
    }

    /**
     * @param value List of CIDR blocks. Indicates which CIDR blocks can access the Amazon EKS public API server endpoint when enabled. EKS defaults this to a list with `0.0.0.0/0`. The provider will only perform drift detection of its value when present in a configuration.
     */
    @JvmName("kuncqclsnxfxqstt")
    public suspend fun publicAccessCidrs(`value`: Output<List<String>>) {
        this.publicAccessCidrs = value
    }

    @JvmName("rfbaturemnfkuufr")
    public suspend fun publicAccessCidrs(vararg values: Output<String>) {
        this.publicAccessCidrs = Output.all(values.asList())
    }

    /**
     * @param values List of CIDR blocks. Indicates which CIDR blocks can access the Amazon EKS public API server endpoint when enabled. EKS defaults this to a list with `0.0.0.0/0`. The provider will only perform drift detection of its value when present in a configuration.
     */
    @JvmName("svicilifpydjwqyi")
    public suspend fun publicAccessCidrs(values: List<Output<String>>) {
        this.publicAccessCidrs = Output.all(values)
    }

    /**
     * @param value List of security group IDs for the cross-account elastic network interfaces that Amazon EKS creates to use to allow communication between your worker nodes and the Kubernetes control plane.
     */
    @JvmName("hvlgmsvnjofdmqtu")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("pecuesfopkcsusol")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values List of security group IDs for the cross-account elastic network interfaces that Amazon EKS creates to use to allow communication between your worker nodes and the Kubernetes control plane.
     */
    @JvmName("umqglaiidvmbkvsm")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value List of subnet IDs. Must be in at least two different availability zones. Amazon EKS creates cross-account elastic network interfaces in these subnets to allow communication between your worker nodes and the Kubernetes control plane.
     */
    @JvmName("hnwwvhhdoqpmxxci")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("wyaiaqprmiggavvi")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values List of subnet IDs. Must be in at least two different availability zones. Amazon EKS creates cross-account elastic network interfaces in these subnets to allow communication between your worker nodes and the Kubernetes control plane.
     */
    @JvmName("lmwbiqkrvnusmqar")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value ID of the VPC associated with your cluster.
     */
    @JvmName("ejmcvjddsnpfsppe")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value Cluster security group that was created by Amazon EKS for the cluster. Managed node groups use this security group for control-plane-to-data-plane communication.
     */
    @JvmName("idibpvvsrcfpwtdq")
    public suspend fun clusterSecurityGroupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterSecurityGroupId = mapped
    }

    /**
     * @param value Whether the Amazon EKS private API server endpoint is enabled. Default is `false`.
     */
    @JvmName("wnankpacxhicqkdx")
    public suspend fun endpointPrivateAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointPrivateAccess = mapped
    }

    /**
     * @param value Whether the Amazon EKS public API server endpoint is enabled. Default is `true`.
     */
    @JvmName("wcaeghsfbosalcdr")
    public suspend fun endpointPublicAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.endpointPublicAccess = mapped
    }

    /**
     * @param value List of CIDR blocks. Indicates which CIDR blocks can access the Amazon EKS public API server endpoint when enabled. EKS defaults this to a list with `0.0.0.0/0`. The provider will only perform drift detection of its value when present in a configuration.
     */
    @JvmName("hljoxyqrowusaooa")
    public suspend fun publicAccessCidrs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.publicAccessCidrs = mapped
    }

    /**
     * @param values List of CIDR blocks. Indicates which CIDR blocks can access the Amazon EKS public API server endpoint when enabled. EKS defaults this to a list with `0.0.0.0/0`. The provider will only perform drift detection of its value when present in a configuration.
     */
    @JvmName("ojjxnfwikgayxyeh")
    public suspend fun publicAccessCidrs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.publicAccessCidrs = mapped
    }

    /**
     * @param value List of security group IDs for the cross-account elastic network interfaces that Amazon EKS creates to use to allow communication between your worker nodes and the Kubernetes control plane.
     */
    @JvmName("ilqtasryvfhsegwa")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values List of security group IDs for the cross-account elastic network interfaces that Amazon EKS creates to use to allow communication between your worker nodes and the Kubernetes control plane.
     */
    @JvmName("okgfyjtaicmpunbv")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value List of subnet IDs. Must be in at least two different availability zones. Amazon EKS creates cross-account elastic network interfaces in these subnets to allow communication between your worker nodes and the Kubernetes control plane.
     */
    @JvmName("nxlslxhkwlfqcijr")
    public suspend fun subnetIds(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values List of subnet IDs. Must be in at least two different availability zones. Amazon EKS creates cross-account elastic network interfaces in these subnets to allow communication between your worker nodes and the Kubernetes control plane.
     */
    @JvmName("dfysuxkhdsflgmoy")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param value ID of the VPC associated with your cluster.
     */
    @JvmName("muobhghhounvhosd")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): ClusterVpcConfigArgs = ClusterVpcConfigArgs(
        clusterSecurityGroupId = clusterSecurityGroupId,
        endpointPrivateAccess = endpointPrivateAccess,
        endpointPublicAccess = endpointPublicAccess,
        publicAccessCidrs = publicAccessCidrs,
        securityGroupIds = securityGroupIds,
        subnetIds = subnetIds ?: throw PulumiNullFieldException("subnetIds"),
        vpcId = vpcId,
    )
}
