@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.inputs

import com.pulumi.aws.eks.inputs.FargateProfileSelectorArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property labels Key-value map of Kubernetes labels for selection.
 * @property namespace Kubernetes namespace for selection.
 * The following arguments are optional:
 */
public data class FargateProfileSelectorArgs(
    public val labels: Output<Map<String, String>>? = null,
    public val namespace: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.eks.inputs.FargateProfileSelectorArgs> {
    override fun toJava(): com.pulumi.aws.eks.inputs.FargateProfileSelectorArgs =
        com.pulumi.aws.eks.inputs.FargateProfileSelectorArgs.builder()
            .labels(labels?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .namespace(namespace.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FargateProfileSelectorArgs].
 */
@PulumiTagMarker
public class FargateProfileSelectorArgsBuilder internal constructor() {
    private var labels: Output<Map<String, String>>? = null

    private var namespace: Output<String>? = null

    /**
     * @param value Key-value map of Kubernetes labels for selection.
     */
    @JvmName("mqmnxowengyuvmoc")
    public suspend fun labels(`value`: Output<Map<String, String>>) {
        this.labels = value
    }

    /**
     * @param value Kubernetes namespace for selection.
     * The following arguments are optional:
     */
    @JvmName("yxnutnedetlhbekt")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value Key-value map of Kubernetes labels for selection.
     */
    @JvmName("lwqduqveoerlmkgd")
    public suspend fun labels(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param values Key-value map of Kubernetes labels for selection.
     */
    @JvmName("unmgsjckkketssrw")
    public fun labels(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.labels = mapped
    }

    /**
     * @param value Kubernetes namespace for selection.
     * The following arguments are optional:
     */
    @JvmName("wmyxamvsvtagtckp")
    public suspend fun namespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    internal fun build(): FargateProfileSelectorArgs = FargateProfileSelectorArgs(
        labels = labels,
        namespace = namespace ?: throw PulumiNullFieldException("namespace"),
    )
}
