@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.inputs

import com.pulumi.aws.eks.inputs.GetAccessEntryPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAccessEntry.
 * @property clusterName Name of the EKS Cluster.
 * @property principalArn The IAM Principal ARN which requires Authentication access to the EKS cluster.
 * @property tags
 */
public data class GetAccessEntryPlainArgs(
    public val clusterName: String,
    public val principalArn: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.eks.inputs.GetAccessEntryPlainArgs> {
    override fun toJava(): com.pulumi.aws.eks.inputs.GetAccessEntryPlainArgs =
        com.pulumi.aws.eks.inputs.GetAccessEntryPlainArgs.builder()
            .clusterName(clusterName.let({ args0 -> args0 }))
            .principalArn(principalArn.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetAccessEntryPlainArgs].
 */
@PulumiTagMarker
public class GetAccessEntryPlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    private var principalArn: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Name of the EKS Cluster.
     */
    @JvmName("cuoxunlltprwwajd")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value The IAM Principal ARN which requires Authentication access to the EKS cluster.
     */
    @JvmName("yetayhqhcwewhgmw")
    public suspend fun principalArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.principalArn = mapped
    }

    /**
     * @param value
     */
    @JvmName("nkilvunpigsvqfds")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("aoucbkkdrobkbxon")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetAccessEntryPlainArgs = GetAccessEntryPlainArgs(
        clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
        principalArn = principalArn ?: throw PulumiNullFieldException("principalArn"),
        tags = tags,
    )
}
