@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.inputs

import com.pulumi.aws.eks.inputs.GetAddonPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAddon.
 * @property addonName Name of the EKS add-on. The name must match one of
 * the names returned by [list-addon](https://docs.aws.amazon.com/cli/latest/reference/eks/list-addons.html).
 * @property clusterName Name of the EKS Cluster.
 * @property tags
 */
public data class GetAddonPlainArgs(
    public val addonName: String,
    public val clusterName: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.eks.inputs.GetAddonPlainArgs> {
    override fun toJava(): com.pulumi.aws.eks.inputs.GetAddonPlainArgs =
        com.pulumi.aws.eks.inputs.GetAddonPlainArgs.builder()
            .addonName(addonName.let({ args0 -> args0 }))
            .clusterName(clusterName.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetAddonPlainArgs].
 */
@PulumiTagMarker
public class GetAddonPlainArgsBuilder internal constructor() {
    private var addonName: String? = null

    private var clusterName: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Name of the EKS add-on. The name must match one of
     * the names returned by [list-addon](https://docs.aws.amazon.com/cli/latest/reference/eks/list-addons.html).
     */
    @JvmName("mkmtyjbhrplmmrbk")
    public suspend fun addonName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.addonName = mapped
    }

    /**
     * @param value Name of the EKS Cluster.
     */
    @JvmName("qxfiyebjpvqqbclq")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    /**
     * @param value
     */
    @JvmName("sktnwbwdcmcgnkdw")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("kthwedwbfcevrjib")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetAddonPlainArgs = GetAddonPlainArgs(
        addonName = addonName ?: throw PulumiNullFieldException("addonName"),
        clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
        tags = tags,
    )
}
