@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.inputs

import com.pulumi.aws.eks.inputs.GetAddonVersionPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAddonVersion.
 * @property addonName Name of the EKS add-on. The name must match one of
 * the names returned by [list-addon](https://docs.aws.amazon.com/cli/latest/reference/eks/list-addons.html).
 * @property kubernetesVersion Version of the EKS Cluster. Must be between 1-100 characters in length. Must begin with an alphanumeric character, and must only contain alphanumeric characters, dashes and underscores (`^[0-9A-Za-z][A-Za-z0-9\-_]+$`).
 * @property mostRecent Determines if the most recent or default version of the addon should be returned.
 */
public data class GetAddonVersionPlainArgs(
    public val addonName: String,
    public val kubernetesVersion: String,
    public val mostRecent: Boolean? = null,
) : ConvertibleToJava<com.pulumi.aws.eks.inputs.GetAddonVersionPlainArgs> {
    override fun toJava(): com.pulumi.aws.eks.inputs.GetAddonVersionPlainArgs =
        com.pulumi.aws.eks.inputs.GetAddonVersionPlainArgs.builder()
            .addonName(addonName.let({ args0 -> args0 }))
            .kubernetesVersion(kubernetesVersion.let({ args0 -> args0 }))
            .mostRecent(mostRecent?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAddonVersionPlainArgs].
 */
@PulumiTagMarker
public class GetAddonVersionPlainArgsBuilder internal constructor() {
    private var addonName: String? = null

    private var kubernetesVersion: String? = null

    private var mostRecent: Boolean? = null

    /**
     * @param value Name of the EKS add-on. The name must match one of
     * the names returned by [list-addon](https://docs.aws.amazon.com/cli/latest/reference/eks/list-addons.html).
     */
    @JvmName("xlrcyfoaamabynsi")
    public suspend fun addonName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.addonName = mapped
    }

    /**
     * @param value Version of the EKS Cluster. Must be between 1-100 characters in length. Must begin with an alphanumeric character, and must only contain alphanumeric characters, dashes and underscores (`^[0-9A-Za-z][A-Za-z0-9\-_]+$`).
     */
    @JvmName("acqtqckwilnekdga")
    public suspend fun kubernetesVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.kubernetesVersion = mapped
    }

    /**
     * @param value Determines if the most recent or default version of the addon should be returned.
     */
    @JvmName("vfqovitsyhsiwnla")
    public suspend fun mostRecent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.mostRecent = mapped
    }

    internal fun build(): GetAddonVersionPlainArgs = GetAddonVersionPlainArgs(
        addonName = addonName ?: throw PulumiNullFieldException("addonName"),
        kubernetesVersion = kubernetesVersion ?: throw PulumiNullFieldException("kubernetesVersion"),
        mostRecent = mostRecent,
    )
}
