@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.inputs

import com.pulumi.aws.eks.inputs.GetNodeGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getNodeGroups.
 * @property clusterName Name of the cluster.
 */
public data class GetNodeGroupsPlainArgs(
    public val clusterName: String,
) : ConvertibleToJava<com.pulumi.aws.eks.inputs.GetNodeGroupsPlainArgs> {
    override fun toJava(): com.pulumi.aws.eks.inputs.GetNodeGroupsPlainArgs =
        com.pulumi.aws.eks.inputs.GetNodeGroupsPlainArgs.builder()
            .clusterName(clusterName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNodeGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetNodeGroupsPlainArgsBuilder internal constructor() {
    private var clusterName: String? = null

    /**
     * @param value Name of the cluster.
     */
    @JvmName("qmeuddiooxtayrel")
    public suspend fun clusterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.clusterName = mapped
    }

    internal fun build(): GetNodeGroupsPlainArgs = GetNodeGroupsPlainArgs(
        clusterName = clusterName ?: throw PulumiNullFieldException("clusterName"),
    )
}
