@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.inputs

import com.pulumi.aws.eks.inputs.NodeGroupLaunchTemplateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property id Identifier of the EC2 Launch Template. Conflicts with `name`.
 * @property name Name of the EC2 Launch Template. Conflicts with `id`.
 * @property version EC2 Launch Template version number. While the API accepts values like `$Default` and `$Latest`, the API will convert the value to the associated version number (e.g., `1`) on read and the provider will show a difference on next plan. Using the `default_version` or `latest_version` attribute of the `aws.ec2.LaunchTemplate` resource or data source is recommended for this argument.
 */
public data class NodeGroupLaunchTemplateArgs(
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val version: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.eks.inputs.NodeGroupLaunchTemplateArgs> {
    override fun toJava(): com.pulumi.aws.eks.inputs.NodeGroupLaunchTemplateArgs =
        com.pulumi.aws.eks.inputs.NodeGroupLaunchTemplateArgs.builder()
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .version(version.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NodeGroupLaunchTemplateArgs].
 */
@PulumiTagMarker
public class NodeGroupLaunchTemplateArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var version: Output<String>? = null

    /**
     * @param value Identifier of the EC2 Launch Template. Conflicts with `name`.
     */
    @JvmName("gjilhqpniyfvokqo")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Name of the EC2 Launch Template. Conflicts with `id`.
     */
    @JvmName("ofoiipwebpouwncd")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value EC2 Launch Template version number. While the API accepts values like `$Default` and `$Latest`, the API will convert the value to the associated version number (e.g., `1`) on read and the provider will show a difference on next plan. Using the `default_version` or `latest_version` attribute of the `aws.ec2.LaunchTemplate` resource or data source is recommended for this argument.
     */
    @JvmName("tpfugfpykpipmjtd")
    public suspend fun version(`value`: Output<String>) {
        this.version = value
    }

    /**
     * @param value Identifier of the EC2 Launch Template. Conflicts with `name`.
     */
    @JvmName("nkxtdwnbbtohnqwq")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Name of the EC2 Launch Template. Conflicts with `id`.
     */
    @JvmName("qmrgcqdquhktvhmt")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value EC2 Launch Template version number. While the API accepts values like `$Default` and `$Latest`, the API will convert the value to the associated version number (e.g., `1`) on read and the provider will show a difference on next plan. Using the `default_version` or `latest_version` attribute of the `aws.ec2.LaunchTemplate` resource or data source is recommended for this argument.
     */
    @JvmName("srfxabeauotwvgem")
    public suspend fun version(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): NodeGroupLaunchTemplateArgs = NodeGroupLaunchTemplateArgs(
        id = id,
        name = name,
        version = version ?: throw PulumiNullFieldException("version"),
    )
}
