@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.inputs

import com.pulumi.aws.eks.inputs.NodeGroupRemoteAccessArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property ec2SshKey EC2 Key Pair name that provides access for remote communication with the worker nodes in the EKS Node Group. If you specify this configuration, but do not specify `source_security_group_ids` when you create an EKS Node Group, either port 3389 for Windows, or port 22 for all other operating systems is opened on the worker nodes to the Internet (0.0.0.0/0). For Windows nodes, this will allow you to use RDP, for all others this allows you to SSH into the worker nodes.
 * @property sourceSecurityGroupIds Set of EC2 Security Group IDs to allow SSH access (port 22) from on the worker nodes. If you specify `ec2_ssh_key`, but do not specify this configuration when you create an EKS Node Group, port 22 on the worker nodes is opened to the Internet (0.0.0.0/0).
 */
public data class NodeGroupRemoteAccessArgs(
    public val ec2SshKey: Output<String>? = null,
    public val sourceSecurityGroupIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.eks.inputs.NodeGroupRemoteAccessArgs> {
    override fun toJava(): com.pulumi.aws.eks.inputs.NodeGroupRemoteAccessArgs =
        com.pulumi.aws.eks.inputs.NodeGroupRemoteAccessArgs.builder()
            .ec2SshKey(ec2SshKey?.applyValue({ args0 -> args0 }))
            .sourceSecurityGroupIds(
                sourceSecurityGroupIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            ).build()
}

/**
 * Builder for [NodeGroupRemoteAccessArgs].
 */
@PulumiTagMarker
public class NodeGroupRemoteAccessArgsBuilder internal constructor() {
    private var ec2SshKey: Output<String>? = null

    private var sourceSecurityGroupIds: Output<List<String>>? = null

    /**
     * @param value EC2 Key Pair name that provides access for remote communication with the worker nodes in the EKS Node Group. If you specify this configuration, but do not specify `source_security_group_ids` when you create an EKS Node Group, either port 3389 for Windows, or port 22 for all other operating systems is opened on the worker nodes to the Internet (0.0.0.0/0). For Windows nodes, this will allow you to use RDP, for all others this allows you to SSH into the worker nodes.
     */
    @JvmName("xjaovdtotyxnpuon")
    public suspend fun ec2SshKey(`value`: Output<String>) {
        this.ec2SshKey = value
    }

    /**
     * @param value Set of EC2 Security Group IDs to allow SSH access (port 22) from on the worker nodes. If you specify `ec2_ssh_key`, but do not specify this configuration when you create an EKS Node Group, port 22 on the worker nodes is opened to the Internet (0.0.0.0/0).
     */
    @JvmName("inqmcmxdniutuggh")
    public suspend fun sourceSecurityGroupIds(`value`: Output<List<String>>) {
        this.sourceSecurityGroupIds = value
    }

    @JvmName("kmsjcuqigexsadyt")
    public suspend fun sourceSecurityGroupIds(vararg values: Output<String>) {
        this.sourceSecurityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values Set of EC2 Security Group IDs to allow SSH access (port 22) from on the worker nodes. If you specify `ec2_ssh_key`, but do not specify this configuration when you create an EKS Node Group, port 22 on the worker nodes is opened to the Internet (0.0.0.0/0).
     */
    @JvmName("ibqrtoncjqieltns")
    public suspend fun sourceSecurityGroupIds(values: List<Output<String>>) {
        this.sourceSecurityGroupIds = Output.all(values)
    }

    /**
     * @param value EC2 Key Pair name that provides access for remote communication with the worker nodes in the EKS Node Group. If you specify this configuration, but do not specify `source_security_group_ids` when you create an EKS Node Group, either port 3389 for Windows, or port 22 for all other operating systems is opened on the worker nodes to the Internet (0.0.0.0/0). For Windows nodes, this will allow you to use RDP, for all others this allows you to SSH into the worker nodes.
     */
    @JvmName("sffdnyktmvlmohek")
    public suspend fun ec2SshKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ec2SshKey = mapped
    }

    /**
     * @param value Set of EC2 Security Group IDs to allow SSH access (port 22) from on the worker nodes. If you specify `ec2_ssh_key`, but do not specify this configuration when you create an EKS Node Group, port 22 on the worker nodes is opened to the Internet (0.0.0.0/0).
     */
    @JvmName("aktwjnpfnphjhnco")
    public suspend fun sourceSecurityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceSecurityGroupIds = mapped
    }

    /**
     * @param values Set of EC2 Security Group IDs to allow SSH access (port 22) from on the worker nodes. If you specify `ec2_ssh_key`, but do not specify this configuration when you create an EKS Node Group, port 22 on the worker nodes is opened to the Internet (0.0.0.0/0).
     */
    @JvmName("peljujgysvmfebpv")
    public suspend fun sourceSecurityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceSecurityGroupIds = mapped
    }

    internal fun build(): NodeGroupRemoteAccessArgs = NodeGroupRemoteAccessArgs(
        ec2SshKey = ec2SshKey,
        sourceSecurityGroupIds = sourceSecurityGroupIds,
    )
}
