@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.inputs

import com.pulumi.aws.eks.inputs.NodeGroupUpdateConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property maxUnavailable Desired max number of unavailable worker nodes during node group update.
 * @property maxUnavailablePercentage Desired max percentage of unavailable worker nodes during node group update.
 */
public data class NodeGroupUpdateConfigArgs(
    public val maxUnavailable: Output<Int>? = null,
    public val maxUnavailablePercentage: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.eks.inputs.NodeGroupUpdateConfigArgs> {
    override fun toJava(): com.pulumi.aws.eks.inputs.NodeGroupUpdateConfigArgs =
        com.pulumi.aws.eks.inputs.NodeGroupUpdateConfigArgs.builder()
            .maxUnavailable(maxUnavailable?.applyValue({ args0 -> args0 }))
            .maxUnavailablePercentage(maxUnavailablePercentage?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [NodeGroupUpdateConfigArgs].
 */
@PulumiTagMarker
public class NodeGroupUpdateConfigArgsBuilder internal constructor() {
    private var maxUnavailable: Output<Int>? = null

    private var maxUnavailablePercentage: Output<Int>? = null

    /**
     * @param value Desired max number of unavailable worker nodes during node group update.
     */
    @JvmName("rnmprecsdvlvrryw")
    public suspend fun maxUnavailable(`value`: Output<Int>) {
        this.maxUnavailable = value
    }

    /**
     * @param value Desired max percentage of unavailable worker nodes during node group update.
     */
    @JvmName("ahjxkuijxvxntvnc")
    public suspend fun maxUnavailablePercentage(`value`: Output<Int>) {
        this.maxUnavailablePercentage = value
    }

    /**
     * @param value Desired max number of unavailable worker nodes during node group update.
     */
    @JvmName("fgqjdamcsmladnwx")
    public suspend fun maxUnavailable(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxUnavailable = mapped
    }

    /**
     * @param value Desired max percentage of unavailable worker nodes during node group update.
     */
    @JvmName("cyjkfpparrovonsl")
    public suspend fun maxUnavailablePercentage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxUnavailablePercentage = mapped
    }

    internal fun build(): NodeGroupUpdateConfigArgs = NodeGroupUpdateConfigArgs(
        maxUnavailable = maxUnavailable,
        maxUnavailablePercentage = maxUnavailablePercentage,
    )
}
