@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property namespaces The namespaces to which the access scope applies when type is namespace.
 * @property type Valid values are `namespace` or `cluster`.
 */
public data class AccessPolicyAssociationAccessScope(
    public val namespaces: List<String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.eks.outputs.AccessPolicyAssociationAccessScope): AccessPolicyAssociationAccessScope = AccessPolicyAssociationAccessScope(
            namespaces = javaType.namespaces().map({ args0 -> args0 }),
            type = javaType.type(),
        )
    }
}
