@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property authenticationMode The authentication mode for the cluster. Valid values are `CONFIG_MAP`, `API` or `API_AND_CONFIG_MAP`
 * @property bootstrapClusterCreatorAdminPermissions Whether or not to bootstrap the access config values to the cluster. Default is `false`.
 */
public data class ClusterAccessConfig(
    public val authenticationMode: String? = null,
    public val bootstrapClusterCreatorAdminPermissions: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.eks.outputs.ClusterAccessConfig): ClusterAccessConfig = ClusterAccessConfig(
            authenticationMode = javaType.authenticationMode().map({ args0 -> args0 }).orElse(null),
            bootstrapClusterCreatorAdminPermissions = javaType.bootstrapClusterCreatorAdminPermissions().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
