@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property provider Configuration block with provider for encryption. Detailed below.
 * @property resources List of strings with resources to be encrypted. Valid values: `secrets`.
 */
public data class ClusterEncryptionConfig(
    public val provider: ClusterEncryptionConfigProvider,
    public val resources: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.eks.outputs.ClusterEncryptionConfig): ClusterEncryptionConfig = ClusterEncryptionConfig(
            provider = javaType.provider().let({ args0 ->
                com.pulumi.aws.eks.kotlin.outputs.ClusterEncryptionConfigProvider.Companion.toKotlin(args0)
            }),
            resources = javaType.resources().map({ args0 -> args0 }),
        )
    }
}
