@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property oidcs Nested block containing [OpenID Connect](https://openid.net/connect/) identity provider information for the cluster. Detailed below.
 */
public data class ClusterIdentity(
    public val oidcs: List<ClusterIdentityOidc>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.eks.outputs.ClusterIdentity): ClusterIdentity =
            ClusterIdentity(
                oidcs = javaType.oidcs().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.eks.kotlin.outputs.ClusterIdentityOidc.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
