@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property supportType Support type to use for the cluster. If the cluster is set to `EXTENDED`, it will enter extended support at the end of standard support. If the cluster is set to `STANDARD`, it will be automatically upgraded at the end of standard support. Valid values are `EXTENDED`, `STANDARD`
 */
public data class ClusterUpgradePolicy(
    public val supportType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.eks.outputs.ClusterUpgradePolicy): ClusterUpgradePolicy = ClusterUpgradePolicy(
            supportType = javaType.supportType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
