@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property labels Key-value map of Kubernetes labels for selection.
 * @property namespace Kubernetes namespace for selection.
 * The following arguments are optional:
 */
public data class FargateProfileSelector(
    public val labels: Map<String, String>? = null,
    public val namespace: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.eks.outputs.FargateProfileSelector): FargateProfileSelector = FargateProfileSelector(
            labels = javaType.labels().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            namespace = javaType.namespace(),
        )
    }
}
