@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A collection of values returned by getAccessEntry.
 * @property accessEntryArn Amazon Resource Name (ARN) of the Access Entry.
 * @property clusterName
 * @property createdAt Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was created.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property kubernetesGroups List of string which can optionally specify the Kubernetes groups the user would belong to when creating an access entry.
 * @property modifiedAt Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was updated.
 * @property principalArn
 * @property tags
 * @property tagsAll (Optional) Key-value map of resource tags, including those inherited from the provider `default_tags` configuration block.
 * @property type Defaults to STANDARD which provides the standard workflow. EC2_LINUX, EC2_WINDOWS, FARGATE_LINUX types disallow users to input a username or groups, and prevent associations.
 * @property userName Defaults to principal ARN if user is principal else defaults to assume-role/session-name is role is used.
 */
public data class GetAccessEntryResult(
    public val accessEntryArn: String,
    public val clusterName: String,
    public val createdAt: String,
    public val id: String,
    public val kubernetesGroups: List<String>,
    public val modifiedAt: String,
    public val principalArn: String,
    public val tags: Map<String, String>? = null,
    public val tagsAll: Map<String, String>,
    public val type: String,
    public val userName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.eks.outputs.GetAccessEntryResult): GetAccessEntryResult = GetAccessEntryResult(
            accessEntryArn = javaType.accessEntryArn(),
            clusterName = javaType.clusterName(),
            createdAt = javaType.createdAt(),
            id = javaType.id(),
            kubernetesGroups = javaType.kubernetesGroups().map({ args0 -> args0 }),
            modifiedAt = javaType.modifiedAt(),
            principalArn = javaType.principalArn(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            tagsAll = javaType.tagsAll().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            userName = javaType.userName(),
        )
    }
}
