@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getAddon.
 * @property addonName
 * @property addonVersion Version of EKS add-on.
 * @property arn ARN of the EKS add-on.
 * @property clusterName
 * @property configurationValues Configuration values for the addon with a single JSON string.
 * @property createdAt Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was created.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property modifiedAt Date and time in [RFC3339 format](https://tools.ietf.org/html/rfc3339#section-5.8) that the EKS add-on was updated.
 * @property serviceAccountRoleArn ARN of IAM role used for EKS add-on. If value is empty -
 * then add-on uses the IAM role assigned to the EKS Cluster node.
 * @property tags
 */
public data class GetAddonResult(
    public val addonName: String,
    public val addonVersion: String,
    public val arn: String,
    public val clusterName: String,
    public val configurationValues: String,
    public val createdAt: String,
    public val id: String,
    public val modifiedAt: String,
    public val serviceAccountRoleArn: String,
    public val tags: Map<String, String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.eks.outputs.GetAddonResult): GetAddonResult =
            GetAddonResult(
                addonName = javaType.addonName(),
                addonVersion = javaType.addonVersion(),
                arn = javaType.arn(),
                clusterName = javaType.clusterName(),
                configurationValues = javaType.configurationValues(),
                createdAt = javaType.createdAt(),
                id = javaType.id(),
                modifiedAt = javaType.modifiedAt(),
                serviceAccountRoleArn = javaType.serviceAccountRoleArn(),
                tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            )
    }
}
