@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getAddonVersion.
 * @property addonName
 * @property id The provider-assigned unique ID for this managed resource.
 * @property kubernetesVersion
 * @property mostRecent
 * @property version Version of the EKS add-on.
 */
public data class GetAddonVersionResult(
    public val addonName: String,
    public val id: String,
    public val kubernetesVersion: String,
    public val mostRecent: Boolean? = null,
    public val version: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.eks.outputs.GetAddonVersionResult): GetAddonVersionResult = GetAddonVersionResult(
            addonName = javaType.addonName(),
            id = javaType.id(),
            kubernetesVersion = javaType.kubernetesVersion(),
            mostRecent = javaType.mostRecent().map({ args0 -> args0 }).orElse(null),
            version = javaType.version(),
        )
    }
}
