@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property authenticationMode Values returned are `CONFIG_MAP`, `API` or `API_AND_CONFIG_MAP`
 * @property bootstrapClusterCreatorAdminPermissions Default to `true`.
 */
public data class GetClusterAccessConfig(
    public val authenticationMode: String,
    public val bootstrapClusterCreatorAdminPermissions: Boolean,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.eks.outputs.GetClusterAccessConfig): GetClusterAccessConfig = GetClusterAccessConfig(
            authenticationMode = javaType.authenticationMode(),
            bootstrapClusterCreatorAdminPermissions = javaType.bootstrapClusterCreatorAdminPermissions(),
        )
    }
}
