@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.eks.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getClusterAuth.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property name
 * @property token Token to use to authenticate with the cluster.
 */
public data class GetClusterAuthResult(
    public val id: String,
    public val name: String,
    public val token: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.eks.outputs.GetClusterAuthResult): GetClusterAuthResult = GetClusterAuthResult(
            id = javaType.id(),
            name = javaType.name(),
            token = javaType.token(),
        )
    }
}
